/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.TableCellRenderer;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.components.table.ClassNameTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.DiffBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.ui.memory.SnapshotAllocResultsPanel;

public class DiffAllocResultsPanel
extends SnapshotAllocResultsPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String GO_SOURCE_POPUP_ITEM_NAME = messages.getString("AllocResultsPanel_GoSourcePopupItemName");
    private AllocMemoryResultsDiff diff;
    private JMenuItem popupShowSource;
    private JPopupMenu memoryResPopupMenu;

    public DiffAllocResultsPanel(AllocMemoryResultsSnapshot snapshot, MemoryResUserActionsHandler actionsHandler) {
        super(snapshot, actionsHandler);
        this.diff = (AllocMemoryResultsDiff)snapshot;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.popupShowSource) {
            this.performDefaultAction(-1);
        }
    }

    protected CustomBarCellRenderer getBarCellRenderer() {
        return new DiffBarCellRenderer(this.diff.getMinObjectsSizePerClassDiff(), this.diff.getMaxObjectsSizePerClassDiff());
    }

    protected JPopupMenu getPopupMenu() {
        if (this.memoryResPopupMenu == null) {
            this.memoryResPopupMenu = new JPopupMenu();
            Font boldfont = this.memoryResPopupMenu.getFont().deriveFont(1);
            this.popupShowSource = new JMenuItem();
            this.popupShowSource.setFont(boldfont);
            this.popupShowSource.setText(GO_SOURCE_POPUP_ITEM_NAME);
            this.memoryResPopupMenu.add(this.popupShowSource);
            this.popupShowSource.addActionListener(this);
        }
        return this.memoryResPopupMenu;
    }

    protected Object computeValueAt(int row, int col) {
        int index = (Integer)this.filteredToFullIndexes.get(row);
        switch (col) {
            case 0: {
                return this.sortedClassNames[index];
            }
            case 1: {
                return new Long(this.totalAllocObjectsSize[index]);
            }
            case 2: {
                return (this.totalAllocObjectsSize[index] > 0L ? "+" : "") + this.intFormat.format(this.totalAllocObjectsSize[index]) + " B";
            }
            case 3: {
                return (this.nTotalAllocObjects[index] > 0 ? "+" : "") + this.intFormat.format(this.nTotalAllocObjects[index]);
            }
        }
        return null;
    }

    protected void initColumnsData() {
        super.initColumnsData();
        ClassNameTableCellRenderer classNameTableCellRenderer = new ClassNameTableCellRenderer();
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(11);
        this.columnRenderers = new TableCellRenderer[]{classNameTableCellRenderer, null, labelTableCellRenderer, labelTableCellRenderer};
    }

    protected void initDataUponResultsFetch() {
        super.initDataUponResultsFetch();
        if (this.barRenderer != null) {
            this.barRenderer.setMinimum(this.diff.getMinObjectsSizePerClassDiff());
            this.barRenderer.setMaximum(this.diff.getMaxObjectsSizePerClassDiff());
        }
    }

    protected boolean passesValueFilter(int i) {
        return true;
    }

    protected void performDefaultAction(int classId) {
        String className = null;
        int selectedRow = this.resTable.getSelectedRow();
        if (selectedRow != -1) {
            className = this.resTable.getValueAt(selectedRow, 0).toString().replaceAll("\\[\\]", "");
        }
        if (className != null) {
            this.actionsHandler.showSourceForMethod(className, null, null);
        }
    }

    protected boolean truncateZeroItems() {
        return false;
    }
}

