/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.treetable;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.ui.components.JTreeTable;
import org.netbeans.lib.profiler.ui.components.treetable.AbstractTreeTableModel;

public class TreeTableModelAdapter
extends AbstractTableModel {
    protected AbstractTreeTableModel treeTableModel;
    protected JTree tree;
    protected JTreeTable treeTable;

    public TreeTableModelAdapter(AbstractTreeTableModel treeTableModel, JTreeTable treeTable) {
        this.treeTable = treeTable;
        this.tree = treeTable.getTree();
        this.treeTableModel = treeTableModel;
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                TreePath[] selectedPaths = TreeTableModelAdapter.this.tree.getSelectionPaths();
                TreeTableModelAdapter.this.fireTableDataChanged();
                TreeTableModelAdapter.this.tree.setSelectionPaths(selectedPaths);
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                TreePath[] selectedPaths = TreeTableModelAdapter.this.tree.getSelectionPaths();
                TreeTableModelAdapter.this.fireTableDataChanged();
                TreeTableModelAdapter.this.tree.setSelectionPaths(selectedPaths);
            }
        });
        treeTableModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeNodesInserted(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeNodesRemoved(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeStructureChanged(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    public boolean isCellEditable(int row, int column) {
        return this.treeTableModel.isCellEditable(this.nodeForRow(row), column);
    }

    public Class getColumnClass(int column) {
        return this.treeTableModel.getColumnClass(column);
    }

    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    public String getColumnName(int column) {
        return this.treeTableModel.getColumnName(column);
    }

    public Vector getExpandedPaths() {
        Enumeration<TreePath> expanded = this.tree.getExpandedDescendants(this.getRootPath());
        Vector<TreePath> paths = new Vector<TreePath>();
        if (expanded != null) {
            while (expanded.hasMoreElements()) {
                paths.add(expanded.nextElement());
            }
        }
        return paths;
    }

    public TreePath getRootPath() {
        return new TreePath(this.treeTableModel.getPathToRoot((CCTNode)this.treeTableModel.getRoot()));
    }

    public int getRowCount() {
        return this.tree.getRowCount();
    }

    public void setValueAt(Object value, int row, int column) {
        this.treeTableModel.setValueAt(value, this.nodeForRow(row), column);
    }

    public Object getValueAt(int row, int column) {
        Object j = this.treeTableModel.getValueAt(this.nodeForRow(row), column);
        return j;
    }

    public void expandRoot() {
        this.tree.expandPath(this.getRootPath());
    }

    public void restoreExpandedPaths(Vector paths) {
        Enumeration e = paths.elements();
        while (e.hasMoreElements()) {
            TreePath path = (TreePath)e.nextElement();
            this.tree.expandPath(path);
        }
    }

    public void updateTreeTable() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Vector pathState = TreeTableModelAdapter.this.getExpandedPaths();
                TreePath[] selectedPaths = TreeTableModelAdapter.this.tree.getSelectionPaths();
                TreeTableModelAdapter.this.treeTableModel.fireTreeStructureChanged(this, TreeTableModelAdapter.this.treeTableModel.getPathToRoot((CCTNode)TreeTableModelAdapter.this.treeTableModel.getRoot()), null, null);
                TreeTableModelAdapter.this.tree.setSelectionPaths(selectedPaths);
                TreeTableModelAdapter.this.restoreExpandedPaths(pathState);
                TreeTableModelAdapter.this.treeTable.getTableHeader().repaint();
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    protected void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreePath[] selectedPaths = TreeTableModelAdapter.this.tree.getSelectionPaths();
                TreeTableModelAdapter.this.fireTableDataChanged();
                TreeTableModelAdapter.this.tree.setSelectionPaths(selectedPaths);
            }
        });
    }

    protected Object nodeForRow(int row) {
        TreePath treePath = this.tree.getPathForRow(row);
        if (treePath != null) {
            return treePath.getLastPathComponent();
        }
        return null;
    }
}

