/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.tree;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.components.tree.TreeCellRendererPersistent;

public class EnhancedTreeCellRenderer
extends JPanel
implements TreeCellRendererPersistent {
    protected Color backgroundNonSelectionColor;
    protected Color backgroundSelectionColor = UIConstants.TABLE_SELECTION_BACKGROUND_COLOR;
    protected Color borderSelectionColor;
    protected Color textNonSelectionColor;
    protected Color textSelectionColor = UIConstants.TABLE_SELECTION_FOREGROUND_COLOR;
    protected boolean hasFocus;
    protected boolean selected;
    private transient Icon closedIcon = UIManager.getIcon("Tree.closedIcon");
    private transient Icon leafIcon = UIManager.getIcon("Tree.leafIcon");
    private transient Icon openIcon = UIManager.getIcon("Tree.openIcon");
    private BorderLayout borderLayout;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JTree tree;

    public EnhancedTreeCellRenderer() {
        this.setOpaque(false);
        this.label1 = new JLabel();
        this.label2 = new JLabel();
        this.label3 = new JLabel();
        this.label2.setFont(this.label1.getFont().deriveFont(1));
        this.borderLayout = new BorderLayout();
        this.setLayout(this.borderLayout);
        JPanel innerPanel = new JPanel();
        innerPanel.setOpaque(false);
        innerPanel.setLayout(new BorderLayout());
        this.add((Component)this.label1, "West");
        this.add((Component)innerPanel, "Center");
        innerPanel.add((Component)this.label2, "West");
        innerPanel.add((Component)this.label3, "Center");
        this.label1.setHorizontalAlignment(2);
        this.setLeafIcon(UIManager.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public void setBackgroundNonSelectionColor(Color newColor) {
        this.backgroundNonSelectionColor = newColor;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color newColor) {
        this.backgroundSelectionColor = newColor;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBorderSelectionColor(Color newColor) {
        this.borderSelectionColor = newColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setClosedIcon(Icon newIcon) {
        this.closedIcon = newIcon;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    public Font getFont() {
        Font font = super.getFont();
        if (font == null && this.tree != null) {
            font = this.tree.getFont();
        }
        return font;
    }

    public void setLeafIcon(Icon newIcon) {
        this.leafIcon = newIcon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setOpenIcon(Icon newIcon) {
        this.openIcon = newIcon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public Dimension getPreferredSize() {
        Dimension retDimension = super.getPreferredSize();
        if (retDimension != null) {
            retDimension = new Dimension(retDimension.width + 3, retDimension.height);
        }
        return retDimension;
    }

    public void setTextNonSelectionColor(Color newColor) {
        this.textNonSelectionColor = newColor;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setTextSelectionColor(Color newColor) {
        this.textSelectionColor = newColor;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
        this.tree = tree;
        this.hasFocus = hasFocus;
        String firstLabel = this.getLabel1Text(value, stringValue);
        this.label1.setText(firstLabel);
        if ("".equals(firstLabel)) {
            this.borderLayout.setHgap(this.label1.getIconTextGap());
        } else {
            this.borderLayout.setHgap(0);
        }
        this.label2.setText(this.getLabel2Text(value, stringValue));
        this.label3.setText(this.getLabel3Text(value, stringValue));
        if (sel) {
            this.label1.setForeground(this.getTextSelectionColor());
            this.label2.setForeground(this.getTextSelectionColor());
            Color c = this.getTextSelectionColor();
            this.label3.setForeground(c.equals(Color.BLACK) ? Color.GRAY : c.brighter());
        } else {
            this.label1.setForeground(this.getTextNonSelectionColor());
            this.label2.setForeground(this.getTextNonSelectionColor());
            Color c = this.getTextNonSelectionColor();
            this.label3.setForeground(c.equals(Color.BLACK) ? Color.GRAY : c.brighter());
        }
        if (!tree.isEnabled()) {
            this.label1.setEnabled(false);
            this.label2.setEnabled(false);
            this.label3.setEnabled(false);
            if (leaf) {
                this.label1.setDisabledIcon(this.getLeafIcon(value));
            } else if (expanded) {
                this.label1.setDisabledIcon(this.getOpenIcon(value));
            } else {
                this.label1.setDisabledIcon(this.getClosedIcon(value));
            }
        } else {
            this.label1.setEnabled(true);
            this.label2.setEnabled(true);
            this.label3.setEnabled(true);
            if (leaf) {
                this.label1.setIcon(this.getLeafIcon(value));
            } else if (expanded) {
                this.label1.setIcon(this.getOpenIcon(value));
            } else {
                this.label1.setIcon(this.getClosedIcon(value));
            }
        }
        this.label1.setComponentOrientation(tree.getComponentOrientation());
        this.selected = sel;
        return this;
    }

    public Component getTreeCellRendererComponentPersistent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        EnhancedTreeCellRenderer renderer = new EnhancedTreeCellRenderer();
        renderer.setLeafIcon(this.leafIcon);
        renderer.setClosedIcon(this.closedIcon);
        renderer.setOpenIcon(this.openIcon);
        return renderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    public void paint(Graphics g) {
        Color bsColor;
        Color bColor;
        if (this.selected) {
            bColor = this.getBackgroundSelectionColor();
        } else {
            bColor = this.getBackgroundNonSelectionColor();
            if (bColor == null) {
                bColor = this.getBackground();
            }
        }
        if (bColor != null) {
            g.setColor(bColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.hasFocus && (bsColor = this.getBorderSelectionColor()) != null) {
            g.setColor(bsColor);
            g.drawRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(g);
    }

    protected Icon getClosedIcon(Object value) {
        return this.getClosedIcon();
    }

    protected String getLabel1Text(Object node, String value) {
        return value;
    }

    protected String getLabel2Text(Object node, String value) {
        return "";
    }

    protected String getLabel3Text(Object node, String value) {
        return "";
    }

    protected Icon getLeafIcon(Object value) {
        return this.getLeafIcon();
    }

    protected Icon getOpenIcon(Object value) {
        return this.getOpenIcon();
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}

