/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.ui.components.AnimationLayout;
import org.netbeans.lib.profiler.ui.components.CustomTaskButtonBorder;

public class AnimatedContainer
extends JPanel {
    public static final int WIDTH = 10;
    public static final int HEIGHT = 20;
    private static final int BOTH = 30;
    private AnimationLayout layout = new AnimationLayout();
    private CustomTaskButtonBorder border;
    private JComponent content;
    private JComponent targetContent;
    private JComponent transContent;
    private int animatedDimension = 30;
    private int origHeight;
    private int origWidth;
    private int targetHeight;
    private int targetWidth;

    public AnimatedContainer(Color backgroundColor) {
        this.setLayout(this.layout);
        this.border = new CustomTaskButtonBorder(backgroundColor, super.getBackground());
        this.setBorder(this.border);
    }

    public void setAnimatedDimension(int dimension) {
        this.animatedDimension = dimension;
    }

    public void setAnimation(JComponent targetContent, JComponent transContent) {
        this.origWidth = this.content.getWidth();
        this.origHeight = this.content.getHeight();
        if (targetContent == null) {
            this.targetContent = this.content;
        } else if (transContent == null) {
            this.transContent = this.content;
        } else {
            this.targetContent = targetContent;
            this.transContent = transContent;
            this.targetWidth = (int)targetContent.getPreferredSize().getWidth();
            this.targetHeight = (int)targetContent.getPreferredSize().getHeight();
        }
    }

    public void setAnimation(JComponent aTargetContent) {
        this.origWidth = this.content.getWidth();
        this.origHeight = this.content.getHeight();
        if (aTargetContent == null) {
            this.targetContent = this.content;
        } else {
            this.targetContent = aTargetContent;
            this.targetWidth = (int)this.targetContent.getPreferredSize().getWidth();
            this.targetHeight = (int)this.targetContent.getPreferredSize().getHeight();
        }
    }

    public void setAnimation(Dimension dimension) {
        this.origWidth = this.content.getWidth();
        this.origHeight = this.content.getHeight();
        this.targetContent = null;
        this.transContent = this.content;
        this.targetWidth = (int)dimension.getWidth();
        this.targetHeight = (int)dimension.getHeight();
    }

    public void setAnimation() {
        this.origWidth = this.content.getWidth();
        this.origHeight = this.content.getHeight();
        this.transContent = this.content;
        this.targetContent = this.content;
    }

    public void setContent(JComponent content) {
        this.content = content;
    }

    public void setDefaultBorder() {
        this.border.setDefault();
        this.repaint();
    }

    public void setFinishState() {
        this.removeAll();
        if (this.targetContent != null) {
            this.add(this.targetContent);
            this.setPreferredSize(new Dimension(this.targetWidth, this.targetHeight));
            this.setMinimumSize(new Dimension(this.targetWidth, this.targetHeight));
        } else if (this.transContent != null) {
            this.add(this.transContent);
            this.setPreferredSize(this.transContent.getPreferredSize());
            this.setMinimumSize(this.transContent.getPreferredSize());
        }
        this.setPreferredSize(this.content.getPreferredSize());
        this.setMinimumSize(this.content.getPreferredSize());
    }

    public void setFocusedBorder() {
        this.border.setFocused();
        this.repaint();
    }

    public void setSelectedBorder() {
        this.border.setSelected();
        this.repaint();
    }

    public void setState(int percents) {
        int newWidth = this.targetWidth;
        int newHeight = this.targetHeight;
        this.origWidth = (int)this.getSize().getWidth();
        this.origHeight = (int)this.getSize().getHeight();
        int deltaWidth = newWidth - this.origWidth;
        int deltaHeight = newHeight - this.origHeight;
        double perc = (double)percents / 100.0;
        Dimension d = this.animatedDimension == 10 ? new Dimension((int)((double)this.origWidth + (double)deltaWidth * perc), this.origHeight) : (this.animatedDimension == 20 ? new Dimension(this.origWidth, (int)((double)this.origHeight + (double)deltaHeight * perc)) : new Dimension((int)((double)this.origWidth + (double)deltaWidth * perc), (int)((double)this.origHeight + (double)deltaHeight * perc)));
        this.setPreferredSize(d);
        this.setMinimumSize(d);
    }

    public void setTargetContent(JComponent targetContent) {
        this.targetContent = targetContent;
    }

    public void setTransContent(JComponent transContent) {
        this.transContent = transContent;
    }

    public Component add(Component component) {
        this.content = (JComponent)component;
        return super.add(component);
    }

    public void lockContentResizing(boolean lock) {
        if (lock && this.transContent != null) {
            this.layout.setLockedSize(this.transContent.getSize());
        } else {
            this.layout.setLockedSize(null);
        }
    }
}

