/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.ui;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.datasupport.DataRemovedListener;
import com.sun.tools.visualvm.core.datasupport.Stateful;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DataSourceCaption<X extends DataSource>
extends JComponent
implements PropertyChangeListener,
DataRemovedListener<DataSource> {
    private static final boolean ANIMATE = Boolean.getBoolean("com.sun.tools.visualvm.core.ui.DataSourceCaption.animate");
    private static final int ANIMATION_RATE = Integer.getInteger("com.sun.tools.visualvm.core.ui.DataSourceCaption.animationRate", 80);
    private static final String APPLICATION_PID_PREFIX = "(pid";
    private static final String APPLICATION_PID_SUFFIX = ")";
    private DataSource dataSource;
    private DataSourceDescriptor<X> dataSourceDescriptor;
    private boolean isAvailable;
    private String name;
    private String description;
    private boolean finished = false;
    private JLabel presenter;
    private Timer busyIconTimer;
    private int busyIconIndex;

    public DataSourceCaption(X dataSource) {
        this.initComponents();
        this.dataSource = dataSource;
        ((DataSource)dataSource).addPropertyChangeListener(this);
        this.dataSourceDescriptor = DataSourceDescriptorFactory.getDescriptor(dataSource);
        this.dataSourceDescriptor.addPropertyChangeListener(this);
        this.initAvailable();
        this.name = this.dataSourceDescriptor.getName();
        this.description = this.dataSourceDescriptor.getDescription();
        this.updateCaption();
        this.updateDescription();
        this.updateAvailable();
        ((DataSource)dataSource).notifyWhenRemoved(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("prop_state".equals(propertyName)) {
            this.isAvailable = (Integer)evt.getNewValue() == 1;
            this.updateAvailable();
            this.updateCaption();
        } else if ("prop_name".equals(propertyName)) {
            this.name = (String)evt.getNewValue();
            this.updateCaption();
        } else if ("prop_description".equals(propertyName)) {
            this.description = (String)evt.getNewValue();
            this.updateDescription();
        } else if ("prop_icon".equals(propertyName)) {
            // empty if block
        }
    }

    @Override
    public void dataRemoved(DataSource dataSource) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DataSourceCaption.this.finish();
                DataSourceCaption.this.isAvailable = false;
                DataSourceCaption.this.updateAvailable();
                DataSourceCaption.this.updateCaption();
            }
        });
    }

    public synchronized void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.dataSource.removePropertyChangeListener(this);
        this.dataSourceDescriptor.removePropertyChangeListener(this);
    }

    private void updateAvailable() {
        if (this.isAvailable) {
            if (ANIMATE) {
                this.busyIconIndex = 0;
                if (this.busyIconTimer == null) {
                    this.createTimer();
                }
                this.busyIconTimer.start();
            } else {
                this.presenter.setIcon(new ImageIcon(this.getClass().getResource("/com/sun/tools/visualvm/core/ui/resources/busy-icon4.png")));
            }
        } else {
            if (this.busyIconTimer != null) {
                this.busyIconTimer.stop();
            }
            this.presenter.setIcon(new ImageIcon(this.getClass().getResource("/com/sun/tools/visualvm/core/ui/resources/idle-icon.png")));
        }
    }

    private void updateCaption() {
        this.name = this.name.replace(">", "&gt;");
        this.name = this.name.replace("<", "&lt;");
        Color textColor = this.isAvailable ? UIManager.getColor("Label.foreground") : UIManager.getColor("Label.disabledForeground");
        String textColorString = "rgb(" + textColor.getRed() + "," + textColor.getGreen() + "," + textColor.getBlue() + APPLICATION_PID_SUFFIX;
        if (this.name.contains(APPLICATION_PID_PREFIX) && this.name.contains(APPLICATION_PID_SUFFIX)) {
            int startPid = this.name.indexOf(APPLICATION_PID_PREFIX);
            String captionBase = this.name.substring(0, startPid).trim();
            String captionPid = this.name.substring(startPid).trim();
            this.presenter.setText("<html><body style='font-size: 1.15em; color: " + textColorString + ";'><nobr>" + "<b>" + captionBase + "</b> " + captionPid + "</nobr></body></html>");
        } else {
            this.presenter.setText("<html><body style='font-size: 1.15em; color: " + textColorString + ";'><nobr>" + "<b>" + this.name + "</b></nobr></body></html>");
        }
    }

    private void updateDescription() {
        if (this.description == null || this.description.trim().length() == 0) {
            this.presenter.setToolTipText(null);
        } else {
            this.presenter.setToolTipText(this.description);
        }
    }

    private void createTimer() {
        final Icon[] busyIcons = new Icon[15];
        for (int i = 0; i < busyIcons.length; ++i) {
            busyIcons[i] = new ImageIcon(this.getClass().getResource("/com/sun/tools/visualvm/core/ui/resources/busy-icon" + i + ".png"));
        }
        this.busyIconTimer = new Timer(ANIMATION_RATE, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!ANIMATE) {
                    if (DataSourceCaption.this.busyIconTimer != null) {
                        DataSourceCaption.this.busyIconTimer.stop();
                    }
                    DataSourceCaption.this.presenter.setIcon(new ImageIcon(this.getClass().getResource("/com/sun/tools/visualvm/core/ui/resources/busy-icon4.png")));
                } else {
                    DataSourceCaption.this.busyIconIndex = (DataSourceCaption.this.busyIconIndex + 1) % busyIcons.length;
                    if (!DataSourceCaption.this.isShowing()) {
                        return;
                    }
                    DataSourceCaption.this.presenter.setIcon(busyIcons[DataSourceCaption.this.busyIconIndex]);
                }
            }
        });
    }

    private void initAvailable() {
        Stateful statefulDataSource;
        this.isAvailable = this.dataSource instanceof Stateful ? (statefulDataSource = (Stateful)((Object)this.dataSource)).getState() == 1 : true;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.presenter = new JLabel();
        this.presenter.setIconTextGap(6);
        this.add((Component)this.presenter, "Center");
    }
}

