/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.explorer;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.explorer.ExplorerContextMenuFactory;
import com.sun.tools.visualvm.core.explorer.ExplorerModelBuilder;
import com.sun.tools.visualvm.core.explorer.ExplorerNodeRenderer;
import com.sun.tools.visualvm.core.explorer.ExplorerSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExplorerComponent
extends JPanel {
    private static ExplorerComponent instance;
    private JTree explorerTree;
    private boolean vetoTreeExpansion = false;

    public static synchronized ExplorerComponent instance() {
        if (instance == null) {
            instance = new ExplorerComponent();
        }
        return instance;
    }

    private ExplorerComponent() {
        this.initComponents();
    }

    public JTree getTree() {
        return this.explorerTree;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.explorerTree = new JTree(ExplorerModelBuilder.getInstance().getModel()){

            protected void processMouseEvent(MouseEvent e) {
                Set<DataSource> selectedDataSources;
                ExplorerComponent.this.vetoTreeExpansion = false;
                if (e.getModifiers() == 16 && e.getClickCount() >= this.getToggleClickCount() && ExplorerComponent.getDefaultAction(selectedDataSources = ExplorerSupport.sharedInstance().getSelectedDataSources()) != null) {
                    ExplorerComponent.this.vetoTreeExpansion = true;
                }
                super.processMouseEvent(e);
            }
        };
        this.explorerTree.setRootVisible(false);
        this.explorerTree.setShowsRootHandles(true);
        this.explorerTree.setRowHeight(ExplorerComponent.getTreeRowHeight());
        this.explorerTree.setCellRenderer(new ExplorerNodeRenderer());
        this.explorerTree.getSelectionModel().setSelectionMode(4);
        this.explorerTree.addKeyListener(new ExplorerTreeKeyAdapter());
        this.explorerTree.addMouseListener(new ExplorerTreeMouseAdapter());
        JScrollPane explorerTreeScrollPane = new JScrollPane(this.explorerTree, 20, 30);
        explorerTreeScrollPane.setBorder(BorderFactory.createEmptyBorder());
        explorerTreeScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        String DEFAULT_ACTION_KEY = "DEFAULT_ACTION";
        this.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), DEFAULT_ACTION_KEY);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), DEFAULT_ACTION_KEY);
        this.getActionMap().put(DEFAULT_ACTION_KEY, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ExplorerComponent.this.performDefaultAction();
            }
        });
        this.explorerTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                if (!ExplorerComponent.this.vetoTreeExpansion) {
                    return;
                }
                ExplorerComponent.this.vetoTreeExpansion = false;
                throw new ExpandVetoException(event);
            }

            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                if (!ExplorerComponent.this.vetoTreeExpansion) {
                    return;
                }
                ExplorerComponent.this.vetoTreeExpansion = false;
                throw new ExpandVetoException(event);
            }
        });
        this.add((Component)explorerTreeScrollPane, "Center");
    }

    private static int getTreeRowHeight() {
        return new JLabel((String)"XXX").getPreferredSize().height + 4;
    }

    private static Action getDefaultAction(Set<DataSource> dataSources) {
        return ExplorerContextMenuFactory.instance().getDefaultActionFor(dataSources);
    }

    private void performDefaultAction() {
        Set<DataSource> selectedDataSources = ExplorerSupport.sharedInstance().getSelectedDataSources();
        Action defaultAction = ExplorerComponent.getDefaultAction(selectedDataSources);
        if (defaultAction != null) {
            defaultAction.actionPerformed(new ActionEvent(selectedDataSources, 0, "Default Action"));
        }
    }

    private void displayContextMenu(int x, int y) {
        JPopupMenu popupMenu = ExplorerContextMenuFactory.instance().createPopupMenu();
        if (popupMenu != null) {
            popupMenu.show(this.explorerTree, x, y);
        }
    }

    private class ExplorerTreeMouseAdapter
    extends MouseAdapter {
        private ExplorerTreeMouseAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            TreePath path = ExplorerComponent.this.explorerTree.getPathForLocation(e.getX(), e.getY());
            if (path != null) {
                if (e.getModifiers() == 4 && !ExplorerComponent.this.explorerTree.isPathSelected(path)) {
                    ExplorerComponent.this.explorerTree.setSelectionPath(path);
                }
            } else {
                ExplorerComponent.this.explorerTree.clearSelection();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getModifiers() == 4) {
                ExplorerComponent.this.displayContextMenu(e.getX(), e.getY());
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getModifiers() == 16 && e.getClickCount() == ExplorerComponent.this.explorerTree.getToggleClickCount()) {
                ExplorerComponent.this.performDefaultAction();
            }
        }
    }

    private class ExplorerTreeKeyAdapter
    extends KeyAdapter {
        private ExplorerTreeKeyAdapter() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 525 || e.getKeyCode() == 121 && e.getModifiers() == 1) {
                int y;
                int x;
                e.consume();
                TreePath path = ExplorerComponent.this.explorerTree.getSelectionPath();
                if (path != null) {
                    Rectangle pathRect = ExplorerComponent.this.explorerTree.getPathBounds(path);
                    x = pathRect.x;
                    y = pathRect.y;
                } else {
                    Point pathPoint = new Point(ExplorerComponent.this.explorerTree.getWidth() / 3, ExplorerComponent.this.explorerTree.getHeight() / 3);
                    x = pathPoint.x;
                    y = pathPoint.y;
                }
                ExplorerComponent.this.displayContextMenu(x, y);
            }
        }
    }
}

