/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.datasource;

import com.sun.tools.visualvm.core.datasource.DataSourceContainer;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.datasupport.ComparableWeakReference;
import com.sun.tools.visualvm.core.datasupport.DataRemovedListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataSource {
    public static final String PROPERTY_VISIBLE = "prop_visible";
    public static final RequestProcessor EVENT_QUEUE = new RequestProcessor("DataSource Event Queue");
    public static final DataSource ROOT = new DataSource(){};
    private DataSource owner;
    private boolean isRemoved = false;
    private DataSource master;
    private boolean visible = true;
    private Storage storage;
    private DataSourceContainer repository;
    private PropertyChangeSupport changeSupport;
    private Set<ComparableWeakReference<DataRemovedListener>> removedListeners;

    public DataSource() {
        this(null);
    }

    public DataSource(DataSource master) {
        this.master = master;
    }

    public final DataSource getOwner() {
        return this.owner;
    }

    public final synchronized void setVisible(boolean newVisible) {
        if (this == ROOT && !newVisible) {
            throw new IllegalArgumentException("DataSourceRoot cannot be hidden");
        }
        boolean oldVisible = this.visible;
        this.visible = newVisible;
        this.getChangeSupport().firePropertyChange(PROPERTY_VISIBLE, oldVisible, newVisible);
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final DataSource getMaster() {
        return this.master;
    }

    public final synchronized Storage getStorage() {
        if (this.storage == null) {
            this.storage = this.createStorage();
            if (this.storage == null) {
                throw new NullPointerException("Storage cannot be null");
            }
        }
        return this.storage;
    }

    public final synchronized DataSourceContainer getRepository() {
        if (this.repository == null) {
            this.repository = new DataSourceContainer(this);
        }
        return this.repository;
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getChangeSupport().addPropertyChangeListener(listener);
    }

    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getChangeSupport().addPropertyChangeListener(propertyName, listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getChangeSupport().removePropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getChangeSupport().removePropertyChangeListener(propertyName, listener);
    }

    public boolean supportsUserRemove() {
        return false;
    }

    public final void notifyWhenRemoved(DataRemovedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        if (this.isRemoved()) {
            listener.dataRemoved(this);
        } else {
            this.getRemovedListeners().add(new ComparableWeakReference<DataRemovedListener>(listener));
        }
    }

    public final boolean isRemoved() {
        return this.isRemoved;
    }

    public boolean checkRemove(DataSource removeRoot) {
        return true;
    }

    protected void remove() {
        this.getStorage().deleteCustomPropertiesStorage();
    }

    final void addImpl(DataSource owner) {
        if (this.isRemoved) {
            throw new UnsupportedOperationException("DataSource can be added only once");
        }
        this.owner = owner;
    }

    final void removeImpl() {
        this.remove();
        this.owner = null;
        this.isRemoved = true;
        if (!this.hasRemovedListeners()) {
            return;
        }
        Set<ComparableWeakReference<DataRemovedListener>> listeners = this.getRemovedListeners();
        for (ComparableWeakReference<DataRemovedListener> listenerReference : listeners) {
            DataRemovedListener listener = (DataRemovedListener)listenerReference.get();
            if (listener == null) continue;
            listener.dataRemoved(this);
        }
        listeners.clear();
    }

    protected Storage createStorage() {
        return new Storage(Storage.getTemporaryStorageDirectory());
    }

    protected final synchronized PropertyChangeSupport getChangeSupport() {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        return this.changeSupport;
    }

    final boolean hasRemovedListeners() {
        return this.removedListeners != null;
    }

    final synchronized Set<ComparableWeakReference<DataRemovedListener>> getRemovedListeners() {
        if (!this.hasRemovedListeners()) {
            this.removedListeners = Collections.synchronizedSet(new HashSet());
        }
        return this.removedListeners;
    }
}

