#!/usr/bin/env kjscmd

var confName = "jsconfigrc";
var groupName = "Blah";

var conf = new Config(this, confName);

var grp = conf.group();

println( "Group=" + grp );

conf.setGroup(groupName);
conf.writeColorEntry("Test Color", "blue");
conf.writeListEntry("Test Array", ["A Value","B Value", "C Value"]);
conf.writeEntry("Test Text", "this is a test");
conf.sync();

var newData = conf.readListEntry("Test Array");
var newColor = conf.readColorEntry("Test Color");
var newText = conf.readEntry("Test Text");
println("Reread Active Config");
println("Groups: " + conf.groupList());
println(newData);
println(newColor);
println(newText);


var newConf = new Config(this, confName);
println("Reread Saved Config");
println("Groups: " + newConf.groupList());
newConf.setGroup(groupName);

newData = newConf.readListEntry("Test Array");
newColor = newConf.readColorEntry("Test Color", "red");
newText = newConf.readEntry("Test Text", "Wrong Text");

println(newData);
println(newColor);
println(newText);

