/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.RefAddr;

public class Reference
implements Cloneable,
Serializable {
    protected Vector addrs;
    protected String classFactory;
    protected String classFactoryLocation;
    protected String className;

    public Reference(String className) {
        this.className = className;
        this.addrs = new Vector();
    }

    public Reference(String className, RefAddr addr) {
        this.className = className;
        this.addrs = new Vector();
        this.addrs.add(addr);
    }

    public Reference(String className, String factory, String factoryLocation) {
        this.className = className;
        this.classFactory = factory;
        this.classFactoryLocation = factoryLocation;
        this.addrs = new Vector();
    }

    public Reference(String className, RefAddr addr, String factory, String factoryLocation) {
        this.className = className;
        this.classFactory = factory;
        this.classFactoryLocation = factoryLocation;
        this.addrs = new Vector();
        this.addrs.add(addr);
    }

    public void add(int posn, RefAddr addr) {
        this.addrs.add(posn, addr);
    }

    public void add(RefAddr addr) {
        this.addrs.add(addr);
    }

    public void clear() {
        this.addrs.clear();
    }

    public Object clone() {
        Reference r = new Reference(this.className, this.classFactory, this.classFactoryLocation);
        r.addrs = (Vector)this.addrs.clone();
        return r;
    }

    private boolean equals(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Reference)) {
            return false;
        }
        Reference r = (Reference)obj;
        return this.equals(this.classFactory, r.classFactory) && this.equals(this.classFactoryLocation, r.classFactoryLocation) && this.equals(this.className, r.className) && this.addrs.equals(r.addrs);
    }

    public RefAddr get(int posn) {
        return (RefAddr)this.addrs.get(posn);
    }

    public RefAddr get(String addrType) {
        for (int i = 0; i < this.addrs.size(); ++i) {
            RefAddr r = (RefAddr)this.addrs.get(i);
            if (!addrType.equals(r.getType())) continue;
            return r;
        }
        return null;
    }

    public Enumeration getAll() {
        return this.addrs.elements();
    }

    public String getClassName() {
        return this.className;
    }

    public String getFactoryClassLocation() {
        return this.classFactoryLocation;
    }

    public String getFactoryClassName() {
        return this.classFactory;
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.addrs.size(); ++i) {
            h += this.addrs.get(i).hashCode();
        }
        return h;
    }

    public Object remove(int posn) {
        return this.addrs.remove(posn);
    }

    public int size() {
        return this.addrs.size();
    }

    public String toString() {
        String x = this.getClass().toString() + "[";
        for (int i = 0; i < this.addrs.size(); ++i) {
            if (i > 0) {
                x = x + ",";
            }
            x = x + this.addrs.get(i).toString();
        }
        return x + "]";
    }
}

