/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.handler;

import com.sun.xml.internal.ws.encoding.jaxb.JAXBTypeSerializer;
import com.sun.xml.internal.ws.encoding.soap.SOAPEPTFactory;
import com.sun.xml.internal.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.internal.ws.handler.HandlerException;
import com.sun.xml.internal.ws.handler.SOAPHandlerContext;
import com.sun.xml.internal.ws.pept.ept.MessageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPMessageContextImpl
implements SOAPMessageContext {
    private SOAPHandlerContext handlerCtxt;
    private MessageContext ctxt;
    private Set<String> roles;
    private static Map<String, Class> allowedTypes = null;
    private boolean failure;

    public SOAPMessageContextImpl(SOAPHandlerContext sOAPHandlerContext) {
        this.handlerCtxt = sOAPHandlerContext;
        this.ctxt = sOAPHandlerContext.getMessageContext();
        if (allowedTypes == null) {
            allowedTypes = new HashMap<String, Class>();
            allowedTypes.put("javax.xml.ws.binding.attachments.inbound", Map.class);
            allowedTypes.put("javax.xml.ws.binding.attachments.outbound", Map.class);
            allowedTypes.put("javax.xml.ws.wsdl.description", InputSource.class);
            allowedTypes.put("javax.xml.ws.wsdl.service", QName.class);
            allowedTypes.put("javax.xml.ws.wsdl.port", QName.class);
            allowedTypes.put("javax.xml.ws.wsdl.interface", QName.class);
            allowedTypes.put("javax.xml.ws.wsdl.operation", QName.class);
            allowedTypes.put("javax.xml.ws.handler.message.outbound", Boolean.class);
        }
    }

    @Override
    public SOAPMessage getMessage() {
        SOAPMessage sOAPMessage = this.handlerCtxt.getSOAPMessage();
        InternalMessage internalMessage = this.handlerCtxt.getInternalMessage();
        if (internalMessage != null || sOAPMessage == null) {
            if (internalMessage != null && sOAPMessage != null) {
                MessageInfo messageInfo = this.handlerCtxt.getMessageInfo();
                SOAPEPTFactory sOAPEPTFactory = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
                sOAPMessage = sOAPEPTFactory.getSOAPEncoder().toSOAPMessage(internalMessage, sOAPMessage);
                this.setMessage(sOAPMessage);
            } else if (internalMessage != null && sOAPMessage == null) {
                MessageInfo messageInfo = this.handlerCtxt.getMessageInfo();
                SOAPEPTFactory sOAPEPTFactory = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
                sOAPMessage = sOAPEPTFactory.getSOAPEncoder().toSOAPMessage(internalMessage, messageInfo);
                this.setMessage(sOAPMessage);
            } else {
                throw new WebServiceException("Don't have SOAPMessage");
            }
        }
        return sOAPMessage;
    }

    @Override
    public void setMessage(SOAPMessage sOAPMessage) {
        this.handlerCtxt.setSOAPMessage(sOAPMessage);
        this.handlerCtxt.setInternalMessage(null);
    }

    @Override
    public Object[] getHeaders(QName qName, JAXBContext jAXBContext, boolean bl) {
        try {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            SOAPMessage sOAPMessage = this.getMessage();
            SOAPHeader sOAPHeader = sOAPMessage.getSOAPHeader();
            if (sOAPHeader == null) {
                return new Object[0];
            }
            Iterator iterator = sOAPHeader.getChildElements(qName);
            while (iterator.hasNext()) {
                DOMSource dOMSource;
                SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)iterator.next();
                if (bl) {
                    dOMSource = new DOMSource(sOAPHeaderElement);
                    arrayList.add(JAXBTypeSerializer.deserialize(dOMSource, jAXBContext));
                    continue;
                }
                if (sOAPHeaderElement.getActor() != null && !this.getRoles().contains(sOAPHeaderElement.getActor())) continue;
                dOMSource = new DOMSource(sOAPHeaderElement);
                arrayList.add(JAXBTypeSerializer.deserialize(dOMSource, jAXBContext));
            }
            return arrayList.toArray();
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
    }

    @Override
    public Set<String> getRoles() {
        return this.roles;
    }

    void setRoles(Set<String> set) {
        this.roles = set;
    }

    private boolean validateProperty(String string, Object object) {
        Class clazz;
        if (allowedTypes.containsKey(string) && !(clazz = allowedTypes.get(string)).isInstance(object)) {
            throw new HandlerException("handler.messageContext.invalid.class", object, string);
        }
        return true;
    }

    @Override
    public void setScope(String string, MessageContext.Scope scope) {
        this.ctxt.setScope(string, scope);
    }

    @Override
    public MessageContext.Scope getScope(String string) {
        return this.ctxt.getScope(string);
    }

    @Override
    public void clear() {
        this.ctxt.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.ctxt.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.ctxt.containsValue(object);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.ctxt.entrySet();
    }

    @Override
    public Object get(Object object) {
        return this.ctxt.get(object);
    }

    @Override
    public boolean isEmpty() {
        return this.ctxt.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.ctxt.keySet();
    }

    @Override
    public Object put(String string, Object object) {
        return this.ctxt.put(string, object);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        this.ctxt.putAll(map);
    }

    @Override
    public Object remove(Object object) {
        return this.ctxt.remove(object);
    }

    @Override
    public int size() {
        return this.ctxt.size();
    }

    @Override
    public Collection<Object> values() {
        return this.ctxt.values();
    }
}

