/*
 * @(#)file      SnmpAccessControlSubSystem.java
 * @(#)author    Sun Microsystems, Inc.
 * @(#)version   1.14
 * @(#)date      06/09/07
 *
 * Copyright 2004 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.sun.jmx.snmp.internal;

import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpUnknownAccContrModelException;
/**
 * Access Control sub system interface. To allow engine integration, an Access Control sub system must implement this interface.
 * <p><b>This API is a Sun Microsystems internal API  and is subject 
 * to change without notice.</b></p>
 * @since 1.5
 */
public interface SnmpAccessControlSubSystem extends SnmpSubSystem {

    /**
     * Method called by the dispatcher in order to control the access at an SNMP pdu Level. 
     * <P> This call is routed by the sub system to the target model according to the SNMP protocol version number.</P>
     * @param version The SNMP protocol version number.
     * @param principal The request principal.
     * @param securityLevel The request security level as defined in <CODE>SnmpEngine</CODE>.
     * @param pduType The pdu type (get, set, ...).
     * @param securityModel The security model ID.
     * @param contextName The access control context name.
     * @param pdu The pdu to check.
     */
    public void checkPduAccess(int version,
			       String principal,
			       int securityLevel,
			       int pduType,
			       int securityModel,
			       byte[] contextName,
			       SnmpPdu pdu) throws SnmpStatusException, SnmpUnknownAccContrModelException;
    /**
     * Method called by the dispatcher in order to control the access at an <CODE>SnmpOid</CODE> Level.
     * This method is called after the <CODE>checkPduAccess</CODE> pdu based method.
     * <P> This call is routed by the sub system to the target model according to the SNMP protocol version number.</P>
     * @param version The SNMP protocol version number.
     * @param principal The request principal.
     * @param securityLevel The request security level as defined in <CODE>SnmpEngine</CODE>.
     * @param pduType The pdu type (get, set, ...).
     * @param securityModel The security model ID.
     * @param contextName The access control context name.
     * @param oid The OID to check.
     */
    public void checkAccess(int version,
			    String principal,
			    int securityLevel,
			    int pduType,
			    int securityModel,
			    byte[] contextName,
			    SnmpOid oid) throws SnmpStatusException, SnmpUnknownAccContrModelException;
}
