/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.generics.visitor;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.tree.ArrayTypeSignature;
import sun.reflect.generics.tree.BooleanSignature;
import sun.reflect.generics.tree.BottomSignature;
import sun.reflect.generics.tree.ByteSignature;
import sun.reflect.generics.tree.CharSignature;
import sun.reflect.generics.tree.ClassTypeSignature;
import sun.reflect.generics.tree.DoubleSignature;
import sun.reflect.generics.tree.FloatSignature;
import sun.reflect.generics.tree.FormalTypeParameter;
import sun.reflect.generics.tree.IntSignature;
import sun.reflect.generics.tree.LongSignature;
import sun.reflect.generics.tree.ShortSignature;
import sun.reflect.generics.tree.SimpleClassTypeSignature;
import sun.reflect.generics.tree.TypeArgument;
import sun.reflect.generics.tree.TypeVariableSignature;
import sun.reflect.generics.tree.VoidDescriptor;
import sun.reflect.generics.tree.Wildcard;
import sun.reflect.generics.visitor.TypeTreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reifier
implements TypeTreeVisitor<Type> {
    private Type resultType;
    private GenericsFactory factory;

    private Reifier(GenericsFactory genericsFactory) {
        this.factory = genericsFactory;
    }

    private GenericsFactory getFactory() {
        return this.factory;
    }

    public static Reifier make(GenericsFactory genericsFactory) {
        return new Reifier(genericsFactory);
    }

    private Type[] reifyTypeArguments(TypeArgument[] typeArgumentArray) {
        Type[] typeArray = new Type[typeArgumentArray.length];
        for (int i = 0; i < typeArgumentArray.length; ++i) {
            typeArgumentArray[i].accept(this);
            typeArray[i] = this.resultType;
        }
        return typeArray;
    }

    @Override
    public Type getResult() {
        assert (this.resultType != null);
        return this.resultType;
    }

    @Override
    public void visitFormalTypeParameter(FormalTypeParameter formalTypeParameter) {
        this.resultType = this.getFactory().makeTypeVariable(formalTypeParameter.getName(), formalTypeParameter.getBounds());
    }

    @Override
    public void visitClassTypeSignature(ClassTypeSignature classTypeSignature) {
        List<SimpleClassTypeSignature> list = classTypeSignature.getPath();
        assert (!list.isEmpty());
        Iterator<SimpleClassTypeSignature> iterator = list.iterator();
        SimpleClassTypeSignature simpleClassTypeSignature = iterator.next();
        String string = simpleClassTypeSignature.getName();
        boolean bl = simpleClassTypeSignature.getDollar();
        while (iterator.hasNext() && simpleClassTypeSignature.getTypeArguments().length == 0) {
            simpleClassTypeSignature = iterator.next();
            bl = simpleClassTypeSignature.getDollar();
            string = string + (bl ? "$" : ".") + simpleClassTypeSignature.getName();
        }
        assert (!iterator.hasNext() || simpleClassTypeSignature.getTypeArguments().length > 0);
        Type type = this.getFactory().makeNamedType(string);
        if (simpleClassTypeSignature.getTypeArguments().length == 0) {
            assert (!iterator.hasNext());
            this.resultType = type;
        } else {
            assert (simpleClassTypeSignature.getTypeArguments().length > 0);
            Type[] typeArray = this.reifyTypeArguments(simpleClassTypeSignature.getTypeArguments());
            ParameterizedType parameterizedType = this.getFactory().makeParameterizedType(type, typeArray, null);
            bl = false;
            while (iterator.hasNext()) {
                simpleClassTypeSignature = iterator.next();
                bl = simpleClassTypeSignature.getDollar();
                string = string + (bl ? "$" : ".") + simpleClassTypeSignature.getName();
                type = this.getFactory().makeNamedType(string);
                typeArray = this.reifyTypeArguments(simpleClassTypeSignature.getTypeArguments());
                parameterizedType = this.getFactory().makeParameterizedType(type, typeArray, parameterizedType);
            }
            this.resultType = parameterizedType;
        }
    }

    @Override
    public void visitArrayTypeSignature(ArrayTypeSignature arrayTypeSignature) {
        arrayTypeSignature.getComponentType().accept(this);
        Type type = this.resultType;
        this.resultType = this.getFactory().makeArrayType(type);
    }

    @Override
    public void visitTypeVariableSignature(TypeVariableSignature typeVariableSignature) {
        this.resultType = this.getFactory().findTypeVariable(typeVariableSignature.getIdentifier());
    }

    @Override
    public void visitWildcard(Wildcard wildcard) {
        this.resultType = this.getFactory().makeWildcard(wildcard.getUpperBounds(), wildcard.getLowerBounds());
    }

    @Override
    public void visitSimpleClassTypeSignature(SimpleClassTypeSignature simpleClassTypeSignature) {
        this.resultType = this.getFactory().makeNamedType(simpleClassTypeSignature.getName());
    }

    @Override
    public void visitBottomSignature(BottomSignature bottomSignature) {
    }

    @Override
    public void visitByteSignature(ByteSignature byteSignature) {
        this.resultType = this.getFactory().makeByte();
    }

    @Override
    public void visitBooleanSignature(BooleanSignature booleanSignature) {
        this.resultType = this.getFactory().makeBool();
    }

    @Override
    public void visitShortSignature(ShortSignature shortSignature) {
        this.resultType = this.getFactory().makeShort();
    }

    @Override
    public void visitCharSignature(CharSignature charSignature) {
        this.resultType = this.getFactory().makeChar();
    }

    @Override
    public void visitIntSignature(IntSignature intSignature) {
        this.resultType = this.getFactory().makeInt();
    }

    @Override
    public void visitLongSignature(LongSignature longSignature) {
        this.resultType = this.getFactory().makeLong();
    }

    @Override
    public void visitFloatSignature(FloatSignature floatSignature) {
        this.resultType = this.getFactory().makeFloat();
    }

    @Override
    public void visitDoubleSignature(DoubleSignature doubleSignature) {
        this.resultType = this.getFactory().makeDouble();
    }

    @Override
    public void visitVoidDescriptor(VoidDescriptor voidDescriptor) {
        this.resultType = this.getFactory().makeVoid();
    }
}

