/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import sun.awt.image.ByteComponentRaster;
import sun.print.PSPrinterJob;
import sun.print.PathGraphics;
import sun.print.ProxyGraphics2D;

class PSPathGraphics
extends PathGraphics {
    private static final int DEFAULT_USER_RES = 72;

    PSPathGraphics(Graphics2D graphics2D, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n, boolean bl) {
        super(graphics2D, printerJob, printable, pageFormat, n, bl);
    }

    public Graphics create() {
        return new PSPathGraphics((Graphics2D)this.getDelegate().create(), this.getPrinterJob(), this.getPrintable(), this.getPageFormat(), this.getPageIndex(), this.canDoRedraws());
    }

    public void fill(Shape shape, Color color) {
        this.deviceFill(shape.getPathIterator(new AffineTransform()), color);
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    public void drawString(String string, float f, float f2) {
        this.drawString(string, f, f2, this.getFont(), this.getFontRenderContext(), 0.0f);
    }

    protected boolean canDrawStringToWidth() {
        return true;
    }

    protected int platformFontCount(Font font, String string) {
        PSPrinterJob pSPrinterJob = (PSPrinterJob)this.getPrinterJob();
        return pSPrinterJob.platformFontCount(font, string);
    }

    protected void drawString(String string, float f, float f2, Font font, FontRenderContext fontRenderContext, float f3) {
        PSPrinterJob pSPrinterJob;
        if (string.length() == 0) {
            return;
        }
        Font font2 = this.getFont();
        if (!font2.equals(font)) {
            this.setFont(font);
        } else {
            font2 = null;
        }
        boolean bl = false;
        boolean bl2 = this.getFont().getTransform().isIdentity();
        if (!PSPrinterJob.shapeTextProp && bl2 && (pSPrinterJob = (PSPrinterJob)this.getPrinterJob()).setFont(this.getFont())) {
            try {
                pSPrinterJob.setColor((Color)this.getPaint());
            }
            catch (ClassCastException classCastException) {
                if (font2 != null) {
                    this.setFont(font2);
                }
                throw new IllegalArgumentException("Expected a Color instance");
            }
            pSPrinterJob.setTransform(this.getTransform());
            pSPrinterJob.setClip(this.getClip());
            bl = pSPrinterJob.textOut(this, string, f, f2, font, fontRenderContext, f3);
        }
        if (!bl) {
            if (font2 != null) {
                this.setFont(font2);
                font2 = null;
            }
            super.drawString(string, f, f2, font, fontRenderContext, f3);
        }
        if (font2 != null) {
            this.setFont(font2);
        }
    }

    protected boolean drawImageToPlatform(Image image, AffineTransform affineTransform, Color color, int n, int n2, int n3, int n4, boolean bl) {
        BufferedImage bufferedImage = this.getBufferedImage(image);
        if (bufferedImage == null) {
            return true;
        }
        PSPrinterJob pSPrinterJob = (PSPrinterJob)this.getPrinterJob();
        AffineTransform affineTransform2 = this.getTransform();
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        affineTransform2.concatenate(affineTransform);
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        Point2D.Float float_ = new Point2D.Float(1.0f, 0.0f);
        Point2D.Float float_2 = new Point2D.Float(0.0f, 1.0f);
        affineTransform2.deltaTransform(float_, float_);
        affineTransform2.deltaTransform(float_2, float_2);
        Point2D.Float float_3 = new Point2D.Float(0.0f, 0.0f);
        double d = float_.distance(float_3);
        double d2 = float_2.distance(float_3);
        if (d != 0.0 && d2 != 0.0) {
            AffineTransform affineTransform3 = new AffineTransform(dArray[0] / d, dArray[1] / d2, dArray[2] / d, dArray[3] / d2, dArray[4] / d, dArray[5] / d2);
            Rectangle2D.Float float_4 = new Rectangle2D.Float(n, n2, n3, n4);
            Shape shape = affineTransform3.createTransformedShape(float_4);
            Rectangle2D rectangle2D = shape.getBounds2D();
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + 0.001, rectangle2D.getHeight() + 0.001);
            int n5 = (int)rectangle2D.getWidth();
            int n6 = (int)rectangle2D.getHeight();
            if (n5 > 0 && n6 > 0) {
                boolean bl2 = true;
                if (!bl && this.hasTransparentPixels(bufferedImage)) {
                    bl2 = false;
                    if (this.isBitmaskTransparency(bufferedImage)) {
                        if (color == null) {
                            if (this.drawBitmaskImage(bufferedImage, affineTransform, color, n, n2, n3, n4)) {
                                return true;
                            }
                        } else if (color.getTransparency() == 1) {
                            bl2 = true;
                        }
                    }
                    if (!this.canDoRedraws()) {
                        bl2 = true;
                    }
                } else {
                    color = null;
                }
                if ((n + n3 > bufferedImage.getWidth(null) || n2 + n4 > bufferedImage.getHeight(null)) && this.canDoRedraws()) {
                    bl2 = false;
                }
                if (!bl2) {
                    pSPrinterJob.saveState(this.getTransform(), this.getClip(), rectangle2D, d, d2, float_4, affineTransform);
                    return true;
                }
                BufferedImage bufferedImage2 = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 5);
                Graphics2D graphics2D = bufferedImage2.createGraphics();
                graphics2D.clipRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
                graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
                graphics2D.transform(affineTransform3);
                if (color == null) {
                    color = Color.white;
                }
                graphics2D.drawImage(bufferedImage, n, n2, n + n3, n2 + n4, n, n2, n + n3, n2 + n4, color, null);
                Shape shape2 = this.getClip();
                Shape shape3 = this.getTransform().createTransformedShape(shape2);
                AffineTransform affineTransform4 = AffineTransform.getScaleInstance(d, d2);
                Shape shape4 = affineTransform4.createTransformedShape(shape);
                Area area = new Area(shape4);
                Area area2 = new Area(shape3);
                area.intersect(area2);
                pSPrinterJob.setClip(area);
                Rectangle2D.Float float_5 = new Rectangle2D.Float((float)(rectangle2D.getX() * d), (float)(rectangle2D.getY() * d2), (float)(rectangle2D.getWidth() * d), (float)(rectangle2D.getHeight() * d2));
                ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage2.getRaster();
                pSPrinterJob.drawImageBGR(byteComponentRaster.getDataStorage(), float_5.x, float_5.y, (float)Math.rint((double)float_5.width + 0.5), (float)Math.rint((double)float_5.height + 0.5), 0.0f, 0.0f, bufferedImage2.getWidth(), bufferedImage2.getHeight(), bufferedImage2.getWidth(), bufferedImage2.getHeight());
                pSPrinterJob.setClip(this.getTransform().createTransformedShape(shape2));
                graphics2D.dispose();
            }
        }
        return true;
    }

    public void redrawRegion(Rectangle2D rectangle2D, double d, double d2, Rectangle2D rectangle2D2, AffineTransform affineTransform) throws PrinterException {
        PSPrinterJob pSPrinterJob = (PSPrinterJob)this.getPrinterJob();
        Printable printable = this.getPrintable();
        PageFormat pageFormat = this.getPageFormat();
        int n = this.getPageIndex();
        BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        ProxyGraphics2D proxyGraphics2D = new ProxyGraphics2D(graphics2D, pSPrinterJob);
        proxyGraphics2D.setColor(Color.white);
        proxyGraphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        proxyGraphics2D.clipRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        proxyGraphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
        float f = (float)(pSPrinterJob.getXRes() / d);
        float f2 = (float)(pSPrinterJob.getYRes() / d2);
        proxyGraphics2D.scale(f / 72.0f, f2 / 72.0f);
        proxyGraphics2D.translate(-pSPrinterJob.getPhysicalPrintableX(pageFormat.getPaper()) / pSPrinterJob.getXRes() * 72.0, -pSPrinterJob.getPhysicalPrintableY(pageFormat.getPaper()) / pSPrinterJob.getYRes() * 72.0);
        proxyGraphics2D.transform(new AffineTransform(this.getPageFormat().getMatrix()));
        proxyGraphics2D.setPaint(Color.black);
        printable.print(proxyGraphics2D, pageFormat, n);
        graphics2D.dispose();
        Shape shape = this.getClip();
        pSPrinterJob.setClip(this.getTransform().createTransformedShape(shape));
        Rectangle2D.Float float_ = new Rectangle2D.Float((float)(rectangle2D.getX() * d), (float)(rectangle2D.getY() * d2), (float)(rectangle2D.getWidth() * d), (float)(rectangle2D.getHeight() * d2));
        ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage.getRaster();
        pSPrinterJob.drawImageBGR(byteComponentRaster.getDataStorage(), float_.x, float_.y, float_.width, float_.height, 0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    protected void deviceFill(PathIterator pathIterator, Color color) {
        PSPrinterJob pSPrinterJob = (PSPrinterJob)this.getPrinterJob();
        pSPrinterJob.deviceFill(pathIterator, color, this.getTransform(), this.getClip());
    }

    protected void deviceFrameRect(int n, int n2, int n3, int n4, Color color) {
        this.draw(new Rectangle2D.Float(n, n2, n3, n4));
    }

    protected void deviceDrawLine(int n, int n2, int n3, int n4, Color color) {
        this.draw(new Line2D.Float(n, n2, n3, n4));
    }

    protected void deviceFillRect(int n, int n2, int n3, int n4, Color color) {
        this.fill(new Rectangle2D.Float(n, n2, n3, n4));
    }

    protected void deviceClip(PathIterator pathIterator) {
    }
}

