/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.WindowEvent;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.KeyboardFocusManagerPeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.MouseInfoPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import sun.awt.AWTAutoShutdown;
import sun.awt.AppContext;
import sun.awt.ComponentFactory;
import sun.awt.DebugHelper;
import sun.awt.DefaultMouseInfoPeer;
import sun.awt.InputMethodSupport;
import sun.awt.KeyboardFocusManagerPeerImpl;
import sun.awt.PeerEvent;
import sun.awt.PostEventQueue;
import sun.awt.WindowClosingListener;
import sun.awt.WindowClosingSupport;
import sun.awt.im.InputContext;
import sun.awt.im.SimpleInputMethodWindow;
import sun.awt.image.ByteArrayImageSource;
import sun.awt.image.FileImageSource;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.ToolkitImage;
import sun.awt.image.URLImageSource;
import sun.font.FontDesignMetrics;
import sun.misc.SoftCache;
import sun.security.action.GetPropertyAction;

public abstract class SunToolkit
extends Toolkit
implements WindowClosingSupport,
WindowClosingListener,
ComponentFactory,
InputMethodSupport {
    private static final Logger log = Logger.getLogger("sun.awt.SunToolkit");
    private static boolean hotjavaUrlCache = false;
    private static Field syncLWRequestsField;
    private static Method wakeupMethod;
    private static Field componentKeyField;
    private static Field menuComponentKeyField;
    private static final String POST_EVENT_QUEUE_KEY = "PostEventQueue";
    protected static final Hashtable peerMap;
    private static final Map appContextMap;
    public static final FontMetrics[] lastMetrics;
    static SoftCache imgCache;
    private static Locale startupLocale;
    private static String dataTransfererClassName;
    private transient WindowClosingListener windowClosingListener;
    private static DefaultMouseInfoPeer mPeer;

    public SunToolkit() {
        Object object;
        DebugHelper.init();
        this.windowClosingListener = null;
        ThreadGroup threadGroup = null;
        String string = System.getProperty("awt.threadgroup", "");
        if (string.length() != 0) {
            try {
                object = Class.forName(string).getConstructor(String.class);
                threadGroup = (ThreadGroup)((Constructor)object).newInstance("AWT-ThreadGroup");
            }
            catch (Exception exception) {
                System.err.println("Failed loading " + string + ": " + exception);
            }
        }
        object = new Runnable(){

            public void run() {
                EventQueue eventQueue;
                String string = Toolkit.getProperty("AWT.EventQueueClass", "java.awt.EventQueue");
                try {
                    eventQueue = (EventQueue)Class.forName(string).newInstance();
                }
                catch (Exception exception) {
                    System.err.println("Failed loading " + string + ": " + exception);
                    eventQueue = new EventQueue();
                }
                AppContext appContext = AppContext.getAppContext();
                appContext.put(AppContext.EVENT_QUEUE_KEY, eventQueue);
                PostEventQueue postEventQueue = new PostEventQueue(eventQueue);
                appContext.put(SunToolkit.POST_EVENT_QUEUE_KEY, postEventQueue);
            }
        };
        if (threadGroup != null) {
            Thread thread = new Thread(threadGroup, (Runnable)object, "EventQueue-Init");
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            object.run();
        }
    }

    public abstract WindowPeer createWindow(Window var1) throws HeadlessException;

    public abstract FramePeer createFrame(Frame var1) throws HeadlessException;

    public abstract DialogPeer createDialog(Dialog var1) throws HeadlessException;

    public abstract ButtonPeer createButton(Button var1) throws HeadlessException;

    public abstract TextFieldPeer createTextField(TextField var1) throws HeadlessException;

    public abstract ChoicePeer createChoice(Choice var1) throws HeadlessException;

    public abstract LabelPeer createLabel(Label var1) throws HeadlessException;

    public abstract ListPeer createList(List var1) throws HeadlessException;

    public abstract CheckboxPeer createCheckbox(Checkbox var1) throws HeadlessException;

    public abstract ScrollbarPeer createScrollbar(Scrollbar var1) throws HeadlessException;

    public abstract ScrollPanePeer createScrollPane(ScrollPane var1) throws HeadlessException;

    public abstract TextAreaPeer createTextArea(TextArea var1) throws HeadlessException;

    public abstract FileDialogPeer createFileDialog(FileDialog var1) throws HeadlessException;

    public abstract MenuBarPeer createMenuBar(MenuBar var1) throws HeadlessException;

    public abstract MenuPeer createMenu(Menu var1) throws HeadlessException;

    public abstract PopupMenuPeer createPopupMenu(PopupMenu var1) throws HeadlessException;

    public abstract MenuItemPeer createMenuItem(MenuItem var1) throws HeadlessException;

    public abstract CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem var1) throws HeadlessException;

    public abstract DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent var1) throws InvalidDnDOperationException;

    public abstract FontPeer getFontPeer(String var1, int var2);

    public abstract RobotPeer createRobot(Robot var1, GraphicsDevice var2) throws AWTException;

    public KeyboardFocusManagerPeer createKeyboardFocusManagerPeer(KeyboardFocusManager keyboardFocusManager) throws HeadlessException {
        KeyboardFocusManagerPeerImpl keyboardFocusManagerPeerImpl = new KeyboardFocusManagerPeerImpl(keyboardFocusManager);
        return keyboardFocusManagerPeerImpl;
    }

    public static AppContext createNewAppContext() {
        EventQueue eventQueue;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        String string = Toolkit.getProperty("AWT.EventQueueClass", "java.awt.EventQueue");
        try {
            eventQueue = (EventQueue)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            System.err.println("Failed loading " + string + ": " + exception);
            eventQueue = new EventQueue();
        }
        AppContext appContext = new AppContext(threadGroup);
        appContext.put(AppContext.EVENT_QUEUE_KEY, eventQueue);
        PostEventQueue postEventQueue = new PostEventQueue(eventQueue);
        appContext.put(POST_EVENT_QUEUE_KEY, postEventQueue);
        return appContext;
    }

    private static Object getPrivateKey(Object object) {
        Object object2;
        block6: {
            object2 = null;
            if (componentKeyField == null || menuComponentKeyField == null) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        block6: {
                            try {
                                componentKeyField = Component.class.getDeclaredField("privateKey");
                                menuComponentKeyField = MenuComponent.class.getDeclaredField("privateKey");
                                if (menuComponentKeyField != null) {
                                    menuComponentKeyField.setAccessible(true);
                                }
                                if (componentKeyField != null) {
                                    componentKeyField.setAccessible(true);
                                }
                            }
                            catch (SecurityException securityException) {
                                assert (false);
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                if ($assertionsDisabled) break block6;
                                throw new AssertionError();
                            }
                        }
                        return null;
                    }
                });
            }
            try {
                if (object instanceof Component) {
                    object2 = componentKeyField.get(object);
                } else if (object instanceof MenuComponent) {
                    object2 = menuComponentKeyField.get(object);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        return object2;
    }

    static void wakeupEventQueue(EventQueue eventQueue, boolean bl) {
        block6: {
            if (wakeupMethod == null) {
                wakeupMethod = (Method)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        block5: {
                            try {
                                Method method = EventQueue.class.getDeclaredMethod("wakeup", Boolean.TYPE);
                                if (method != null) {
                                    method.setAccessible(true);
                                }
                                return method;
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                assert (false);
                            }
                            catch (SecurityException securityException) {
                                if ($assertionsDisabled) break block5;
                                throw new AssertionError();
                            }
                        }
                        return null;
                    }
                });
            }
            try {
                if (wakeupMethod != null) {
                    wakeupMethod.invoke(eventQueue, bl);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                assert (false);
            }
            catch (IllegalAccessException illegalAccessException) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    protected static Object targetToPeer(Object object) {
        if (object != null && !GraphicsEnvironment.isHeadless()) {
            return peerMap.get(SunToolkit.getPrivateKey(object));
        }
        return null;
    }

    protected static void targetCreatedPeer(Object object, Object object2) {
        if (object != null && object2 != null && !GraphicsEnvironment.isHeadless()) {
            peerMap.put(SunToolkit.getPrivateKey(object), object2);
        }
    }

    protected static void targetDisposedPeer(Object object, Object object2) {
        Object object3;
        if (object != null && object2 != null && !GraphicsEnvironment.isHeadless() && peerMap.get(object3 = SunToolkit.getPrivateKey(object)) == object2) {
            peerMap.remove(object3);
        }
    }

    private static native boolean setAppContext(Object var0, AppContext var1);

    private static native AppContext getAppContext(Object var0);

    public static AppContext targetToAppContext(Object object) {
        if (object == null || GraphicsEnvironment.isHeadless()) {
            return null;
        }
        AppContext appContext = SunToolkit.getAppContext(object);
        if (appContext == null) {
            appContext = (AppContext)appContextMap.get(object);
        }
        return appContext;
    }

    public static void setLWRequestStatus(Window window, boolean bl) {
        block4: {
            if (syncLWRequestsField == null) {
                syncLWRequestsField = (Field)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        block5: {
                            try {
                                Field field = Window.class.getDeclaredField("syncLWRequests");
                                if (field != null) {
                                    field.setAccessible(true);
                                }
                                return field;
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                assert (false);
                            }
                            catch (SecurityException securityException) {
                                if ($assertionsDisabled) break block5;
                                throw new AssertionError();
                            }
                        }
                        return null;
                    }
                });
            }
            try {
                if (syncLWRequestsField != null) {
                    syncLWRequestsField.setBoolean(window, bl);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    public static void checkAndSetPolicy(Container container, boolean bl) {
        FocusTraversalPolicy focusTraversalPolicy = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalPolicy();
        String string = Toolkit.getDefaultToolkit().getClass().getName();
        if (!"sun.awt.X11.XToolkit".equals(string)) {
            container.setFocusTraversalPolicy(focusTraversalPolicy);
            return;
        }
        String string2 = focusTraversalPolicy.getClass().getName();
        if (DefaultFocusTraversalPolicy.class != focusTraversalPolicy.getClass()) {
            if (string2.startsWith("java.awt.")) {
                if (bl) {
                    focusTraversalPolicy = SunToolkit.createLayoutPolicy();
                }
            } else if (string2.startsWith("javax.swing.") && !bl) {
                focusTraversalPolicy = new DefaultFocusTraversalPolicy();
            }
        } else if (bl) {
            focusTraversalPolicy = SunToolkit.createLayoutPolicy();
        }
        container.setFocusTraversalPolicy(focusTraversalPolicy);
    }

    private static FocusTraversalPolicy createLayoutPolicy() {
        FocusTraversalPolicy focusTraversalPolicy;
        block6: {
            focusTraversalPolicy = null;
            try {
                Class<?> clazz = Class.forName("javax.swing.LayoutFocusTraversalPolicy");
                focusTraversalPolicy = (FocusTraversalPolicy)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                assert (false);
            }
            catch (InstantiationException instantiationException) {
                assert (false);
            }
            catch (IllegalAccessException illegalAccessException) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        return focusTraversalPolicy;
    }

    public static void insertTargetMapping(Object object, AppContext appContext) {
        if (!GraphicsEnvironment.isHeadless() && !SunToolkit.setAppContext(object, appContext)) {
            appContextMap.put(object, appContext);
        }
    }

    public static void postEvent(AppContext appContext, AWTEvent aWTEvent) {
        PostEventQueue postEventQueue;
        if (aWTEvent == null) {
            throw new NullPointerException();
        }
        AppContext appContext2 = SunToolkit.targetToAppContext(aWTEvent.getSource());
        if (appContext2 != null && !appContext2.equals(appContext)) {
            log.fine("Event posted on wrong app context : " + aWTEvent);
        }
        if ((postEventQueue = (PostEventQueue)appContext.get(POST_EVENT_QUEUE_KEY)) != null) {
            postEventQueue.postEvent(aWTEvent);
        }
    }

    public static void flushPendingEvents() {
        AppContext appContext = AppContext.getAppContext();
        PostEventQueue postEventQueue = (PostEventQueue)appContext.get(POST_EVENT_QUEUE_KEY);
        if (postEventQueue != null) {
            postEventQueue.flush();
        }
    }

    public static boolean isPostEventQueueEmpty() {
        AppContext appContext = AppContext.getAppContext();
        PostEventQueue postEventQueue = (PostEventQueue)appContext.get(POST_EVENT_QUEUE_KEY);
        if (postEventQueue != null) {
            return postEventQueue.noEvents();
        }
        return true;
    }

    public static void executeOnEventHandlerThread(Object object, Runnable runnable) {
        SunToolkit.executeOnEventHandlerThread(new PeerEvent(object, runnable, 1L));
    }

    public static void executeOnEventHandlerThread(PeerEvent peerEvent) {
        SunToolkit.postEvent(SunToolkit.targetToAppContext(peerEvent.getSource()), peerEvent);
    }

    public Dimension getScreenSize() {
        return new Dimension(this.getScreenWidth(), this.getScreenHeight());
    }

    protected abstract int getScreenWidth();

    protected abstract int getScreenHeight();

    public FontMetrics getFontMetrics(Font font) {
        FontMetrics fontMetrics;
        for (int i = 0; i < lastMetrics.length && (fontMetrics = lastMetrics[i]) != null; ++i) {
            if (fontMetrics.getFont() != font) continue;
            return fontMetrics;
        }
        FontDesignMetrics fontDesignMetrics = new FontDesignMetrics(font);
        System.arraycopy(lastMetrics, 0, lastMetrics, 1, lastMetrics.length - 1);
        SunToolkit.lastMetrics[0] = fontDesignMetrics;
        return fontDesignMetrics;
    }

    public String[] getFontList() {
        String[] stringArray = new String[]{"Dialog", "SansSerif", "Serif", "Monospaced", "DialogInput"};
        return stringArray;
    }

    public PanelPeer createPanel(Panel panel) {
        return (PanelPeer)((Object)this.createComponent(panel));
    }

    public CanvasPeer createCanvas(Canvas canvas) {
        return (CanvasPeer)((Object)this.createComponent(canvas));
    }

    static synchronized Image getImageFromHash(Toolkit toolkit, URL uRL) {
        Object object;
        block10: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    object = uRL.openConnection().getPermission();
                    if (object == null) break block10;
                    try {
                        securityManager.checkPermission((Permission)object);
                    }
                    catch (SecurityException securityException) {
                        if (object instanceof FilePermission && ((Permission)object).getActions().indexOf("read") != -1) {
                            securityManager.checkRead(((Permission)object).getName());
                            break block10;
                        }
                        if (object instanceof SocketPermission && ((Permission)object).getActions().indexOf("connect") != -1) {
                            securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                            break block10;
                        }
                        throw securityException;
                    }
                }
                catch (IOException iOException) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
            }
        }
        if ((object = (Image)imgCache.get(uRL)) == null) {
            try {
                object = toolkit.createImage(new URLImageSource(uRL));
                imgCache.put(uRL, object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object;
    }

    static synchronized Image getImageFromHash(Toolkit toolkit, String string) {
        Image image;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        if ((image = (Image)imgCache.get(string)) == null) {
            try {
                image = toolkit.createImage(new FileImageSource(string));
                imgCache.put(string, image);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return image;
    }

    public Image getImage(String string) {
        return SunToolkit.getImageFromHash((Toolkit)this, string);
    }

    public Image getImage(URL uRL) {
        return SunToolkit.getImageFromHash((Toolkit)this, uRL);
    }

    public Image createImage(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        return this.createImage(new FileImageSource(string));
    }

    public Image createImage(URL uRL) {
        block7: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    Permission permission = uRL.openConnection().getPermission();
                    if (permission == null) break block7;
                    try {
                        securityManager.checkPermission(permission);
                    }
                    catch (SecurityException securityException) {
                        if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                            securityManager.checkRead(permission.getName());
                            break block7;
                        }
                        if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                            securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                            break block7;
                        }
                        throw securityException;
                    }
                }
                catch (IOException iOException) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
            }
        }
        return this.createImage(new URLImageSource(uRL));
    }

    public Image createImage(byte[] byArray, int n, int n2) {
        return this.createImage(new ByteArrayImageSource(byArray, n, n2));
    }

    public Image createImage(ImageProducer imageProducer) {
        return new ToolkitImage(imageProducer);
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (!(image instanceof ToolkitImage)) {
            return 32;
        }
        ToolkitImage toolkitImage = (ToolkitImage)image;
        int n3 = n == 0 || n2 == 0 ? 32 : toolkitImage.getImageRep().check(imageObserver);
        return toolkitImage.check(imageObserver) | n3;
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (n == 0 || n2 == 0) {
            return true;
        }
        if (!(image instanceof ToolkitImage)) {
            return true;
        }
        ToolkitImage toolkitImage = (ToolkitImage)image;
        if (toolkitImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = toolkitImage.getImageRep();
        return imageRepresentation.prepare(imageObserver);
    }

    protected EventQueue getSystemEventQueueImpl() {
        return SunToolkit.getSystemEventQueueImplPP();
    }

    static EventQueue getSystemEventQueueImplPP() {
        AppContext appContext = AppContext.getAppContext();
        EventQueue eventQueue = (EventQueue)appContext.get(AppContext.EVENT_QUEUE_KEY);
        return eventQueue;
    }

    public static Container getNativeContainer(Component component) {
        return Toolkit.getNativeContainer(component);
    }

    public Window createInputMethodWindow(String string, InputContext inputContext) {
        return new SimpleInputMethodWindow(string, inputContext);
    }

    public boolean enableInputMethodsForTextComponent() {
        return false;
    }

    public static Locale getStartupLocale() {
        if (startupLocale == null) {
            String string;
            String string2;
            String string3 = (String)AccessController.doPrivileged(new GetPropertyAction("user.language", "en"));
            String string4 = (String)AccessController.doPrivileged(new GetPropertyAction("user.region"));
            if (string4 != null) {
                int n = string4.indexOf(95);
                if (n >= 0) {
                    string2 = string4.substring(0, n);
                    string = string4.substring(n + 1);
                } else {
                    string2 = string4;
                    string = "";
                }
            } else {
                string2 = (String)AccessController.doPrivileged(new GetPropertyAction("user.country", ""));
                string = (String)AccessController.doPrivileged(new GetPropertyAction("user.variant", ""));
            }
            startupLocale = new Locale(string3, string2, string);
        }
        return startupLocale;
    }

    public Locale getDefaultKeyboardLocale() {
        return SunToolkit.getStartupLocale();
    }

    protected static void setDataTransfererClassName(String string) {
        dataTransfererClassName = string;
    }

    public static String getDataTransfererClassName() {
        if (dataTransfererClassName == null) {
            Toolkit.getDefaultToolkit();
        }
        return dataTransfererClassName;
    }

    public WindowClosingListener getWindowClosingListener() {
        return this.windowClosingListener;
    }

    public void setWindowClosingListener(WindowClosingListener windowClosingListener) {
        this.windowClosingListener = windowClosingListener;
    }

    public RuntimeException windowClosingNotify(WindowEvent windowEvent) {
        if (this.windowClosingListener != null) {
            return this.windowClosingListener.windowClosingNotify(windowEvent);
        }
        return null;
    }

    public RuntimeException windowClosingDelivered(WindowEvent windowEvent) {
        if (this.windowClosingListener != null) {
            return this.windowClosingListener.windowClosingDelivered(windowEvent);
        }
        return null;
    }

    protected synchronized MouseInfoPeer getMouseInfoPeer() {
        if (mPeer == null) {
            mPeer = new DefaultMouseInfoPeer();
        }
        return mPeer;
    }

    public static boolean needsXEmbed() {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.awt.noxembed", "false"));
        if ("true".equals(string)) {
            return false;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof SunToolkit) {
            return ((SunToolkit)toolkit).needsXEmbedImpl();
        }
        return false;
    }

    protected boolean needsXEmbedImpl() {
        return false;
    }

    public static boolean isModalExcludedSupported() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof SunToolkit) {
            return ((SunToolkit)toolkit).isModalExcludedSupportedImpl();
        }
        return false;
    }

    protected boolean isModalExcludedSupportedImpl() {
        return false;
    }

    public static void setModalExcluded(Window window) {
        SunToolkit.setTargetModalExcludedProp(window);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof SunToolkit) {
            ((SunToolkit)toolkit).setModalExcludedImpl(window);
        }
        Window[] windowArray = window.getOwnedWindows();
        for (int i = 0; i < windowArray.length; ++i) {
            SunToolkit.setModalExcluded(windowArray[i]);
        }
    }

    private static void setTargetModalExcludedProp(Window window) {
        try {
            final Window window2 = window;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Field field = Window.class.getDeclaredField("modalExcluded");
                        field.setAccessible(true);
                        field.setBoolean(window2, true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    protected void setModalExcludedImpl(Window window) {
    }

    public static boolean isModalExcluded(Window window) {
        boolean bl = false;
        try {
            final Window window2 = window;
            bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    boolean bl = false;
                    try {
                        Field field = Window.class.getDeclaredField("modalExcluded");
                        field.setAccessible(true);
                        bl = field.getBoolean(window2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return bl;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static boolean isLightweightOrUnknown(Component component) {
        if (component.isLightweight() || !(SunToolkit.getDefaultToolkit() instanceof SunToolkit)) {
            return true;
        }
        return !(component instanceof Button) && !(component instanceof Canvas) && !(component instanceof Checkbox) && !(component instanceof Choice) && !(component instanceof Label) && !(component instanceof List) && !(component instanceof Panel) && !(component instanceof Scrollbar) && !(component instanceof ScrollPane) && !(component instanceof TextArea) && !(component instanceof TextField) && !(component instanceof Window);
    }

    static Method getMethod(final Class clazz, final String string, final Class[] classArray) {
        Method method = null;
        try {
            method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Method method = clazz.getDeclaredMethod(string, classArray);
                    method.setAccessible(true);
                    return method;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            privilegedActionException.printStackTrace();
        }
        return method;
    }

    static {
        peerMap = AWTAutoShutdown.getInstance().getPeerMap();
        appContextMap = Collections.synchronizedMap(new WeakHashMap());
        lastMetrics = new FontMetrics[5];
        imgCache = new SoftCache();
        startupLocale = null;
        dataTransfererClassName = null;
        mPeer = null;
    }
}

