/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.axes;

import com.sun.org.apache.xml.internal.dtm.DTM;
import com.sun.org.apache.xml.internal.dtm.DTMIterator;
import com.sun.org.apache.xml.internal.utils.WrappedRuntimeException;
import com.sun.org.apache.xpath.internal.Expression;
import com.sun.org.apache.xpath.internal.ExpressionOwner;
import com.sun.org.apache.xpath.internal.XPathVisitor;
import com.sun.org.apache.xpath.internal.axes.FilterExprWalker;
import com.sun.org.apache.xpath.internal.axes.HasPositionalPredChecker;
import com.sun.org.apache.xpath.internal.axes.IteratorPool;
import com.sun.org.apache.xpath.internal.axes.LocPathIterator;
import com.sun.org.apache.xpath.internal.axes.PathComponent;
import com.sun.org.apache.xpath.internal.axes.UnionChildIterator;
import com.sun.org.apache.xpath.internal.axes.WalkerFactory;
import com.sun.org.apache.xpath.internal.axes.WalkingIterator;
import com.sun.org.apache.xpath.internal.compiler.Compiler;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class UnionPathIterator
extends LocPathIterator
implements Cloneable,
DTMIterator,
Serializable,
PathComponent {
    protected LocPathIterator[] m_exprs;
    protected DTMIterator[] m_iterators;

    public UnionPathIterator() {
        this.m_iterators = null;
        this.m_exprs = null;
    }

    public void setRoot(int n, Object object) {
        super.setRoot(n, object);
        try {
            if (null != this.m_exprs) {
                int n2 = this.m_exprs.length;
                DTMIterator[] dTMIteratorArray = new DTMIterator[n2];
                for (int i = 0; i < n2; ++i) {
                    DTMIterator dTMIterator;
                    dTMIteratorArray[i] = dTMIterator = this.m_exprs[i].asIterator(this.m_execContext, n);
                    dTMIterator.nextNode();
                }
                this.m_iterators = dTMIteratorArray;
            }
        }
        catch (Exception exception) {
            throw new WrappedRuntimeException(exception);
        }
    }

    public void addIterator(DTMIterator dTMIterator) {
        if (null == this.m_iterators) {
            this.m_iterators = new DTMIterator[1];
            this.m_iterators[0] = dTMIterator;
        } else {
            DTMIterator[] dTMIteratorArray = this.m_iterators;
            int n = this.m_iterators.length;
            this.m_iterators = new DTMIterator[n + 1];
            System.arraycopy(dTMIteratorArray, 0, this.m_iterators, 0, n);
            this.m_iterators[n] = dTMIterator;
        }
        dTMIterator.nextNode();
        if (dTMIterator instanceof Expression) {
            ((Expression)((Object)dTMIterator)).exprSetParent(this);
        }
    }

    public void detach() {
        if (this.m_allowDetach && null != this.m_iterators) {
            int n = this.m_iterators.length;
            for (int i = 0; i < n; ++i) {
                this.m_iterators[i].detach();
            }
            this.m_iterators = null;
        }
    }

    public UnionPathIterator(Compiler compiler, int n) throws TransformerException {
        n = Compiler.getFirstChildPos(n);
        this.loadLocationPaths(compiler, n, 0);
    }

    public static LocPathIterator createUnionIterator(Compiler compiler, int n) throws TransformerException {
        UnionPathIterator unionPathIterator = new UnionPathIterator(compiler, n);
        int n2 = unionPathIterator.m_exprs.length;
        boolean bl = true;
        for (int i = 0; i < n2; ++i) {
            LocPathIterator locPathIterator = unionPathIterator.m_exprs[i];
            if (locPathIterator.getAxis() != 3) {
                bl = false;
                break;
            }
            if (!HasPositionalPredChecker.check(locPathIterator)) continue;
            bl = false;
            break;
        }
        if (bl) {
            UnionChildIterator unionChildIterator = new UnionChildIterator();
            for (int i = 0; i < n2; ++i) {
                LocPathIterator locPathIterator = unionPathIterator.m_exprs[i];
                unionChildIterator.addNodeTest(locPathIterator);
            }
            return unionChildIterator;
        }
        return unionPathIterator;
    }

    public int getAnalysisBits() {
        int n = 0;
        if (this.m_exprs != null) {
            int n2 = this.m_exprs.length;
            for (int i = 0; i < n2; ++i) {
                int n3 = this.m_exprs[i].getAnalysisBits();
                n |= n3;
            }
        }
        return n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, TransformerException {
        try {
            objectInputStream.defaultReadObject();
            this.m_clones = new IteratorPool(this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TransformerException(classNotFoundException);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        UnionPathIterator unionPathIterator = (UnionPathIterator)super.clone();
        return unionPathIterator;
    }

    protected LocPathIterator createDTMIterator(Compiler compiler, int n) throws TransformerException {
        LocPathIterator locPathIterator = (LocPathIterator)WalkerFactory.newDTMIterator(compiler, n, compiler.getLocationPathDepth() <= 0);
        return locPathIterator;
    }

    protected void loadLocationPaths(Compiler compiler, int n, int n2) throws TransformerException {
        int n3 = compiler.getOp(n);
        if (n3 == 28) {
            this.loadLocationPaths(compiler, compiler.getNextOpPos(n), n2 + 1);
            this.m_exprs[n2] = this.createDTMIterator(compiler, n);
            this.m_exprs[n2].exprSetParent(this);
        } else {
            switch (n3) {
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    this.loadLocationPaths(compiler, compiler.getNextOpPos(n), n2 + 1);
                    WalkingIterator walkingIterator = new WalkingIterator(compiler.getNamespaceContext());
                    walkingIterator.exprSetParent(this);
                    if (compiler.getLocationPathDepth() <= 0) {
                        walkingIterator.setIsTopLevel(true);
                    }
                    walkingIterator.m_firstWalker = new FilterExprWalker(walkingIterator);
                    walkingIterator.m_firstWalker.init(compiler, n, n3);
                    this.m_exprs[n2] = walkingIterator;
                    break;
                }
                default: {
                    this.m_exprs = new LocPathIterator[n2];
                }
            }
        }
    }

    public int nextNode() {
        if (this.m_foundLast) {
            return -1;
        }
        int n = -1;
        if (null != this.m_iterators) {
            int n2 = this.m_iterators.length;
            int n3 = -1;
            for (int i = 0; i < n2; ++i) {
                int n4 = this.m_iterators[i].getCurrentNode();
                if (-1 == n4) continue;
                if (-1 == n) {
                    n3 = i;
                    n = n4;
                    continue;
                }
                if (n4 == n) {
                    this.m_iterators[i].nextNode();
                    continue;
                }
                DTM dTM = this.getDTM(n4);
                if (!dTM.isNodeAfter(n4, n)) continue;
                n3 = i;
                n = n4;
            }
            if (-1 != n) {
                this.m_iterators[n3].nextNode();
                this.incrementCurrentPos();
            } else {
                this.m_foundLast = true;
            }
        }
        this.m_lastFetched = n;
        return n;
    }

    public void fixupVariables(Vector vector, int n) {
        for (int i = 0; i < this.m_exprs.length; ++i) {
            this.m_exprs[i].fixupVariables(vector, n);
        }
    }

    public int getAxis() {
        return -1;
    }

    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        if (xPathVisitor.visitUnionPath(expressionOwner, this) && null != this.m_exprs) {
            int n = this.m_exprs.length;
            for (int i = 0; i < n; ++i) {
                this.m_exprs[i].callVisitors(new iterOwner(i), xPathVisitor);
            }
        }
    }

    public boolean deepEquals(Expression expression) {
        if (!super.deepEquals(expression)) {
            return false;
        }
        UnionPathIterator unionPathIterator = (UnionPathIterator)expression;
        if (null != this.m_exprs) {
            int n = this.m_exprs.length;
            if (null == unionPathIterator.m_exprs || unionPathIterator.m_exprs.length != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.m_exprs[i].deepEquals(unionPathIterator.m_exprs[i])) continue;
                return false;
            }
        } else if (null != unionPathIterator.m_exprs) {
            return false;
        }
        return true;
    }

    class iterOwner
    implements ExpressionOwner {
        int m_index;

        iterOwner(int n) {
            this.m_index = n;
        }

        public Expression getExpression() {
            return UnionPathIterator.this.m_exprs[this.m_index];
        }

        public void setExpression(Expression expression) {
            if (!(expression instanceof LocPathIterator)) {
                WalkingIterator walkingIterator = new WalkingIterator(UnionPathIterator.this.getPrefixResolver());
                FilterExprWalker filterExprWalker = new FilterExprWalker(walkingIterator);
                walkingIterator.setFirstWalker(filterExprWalker);
                filterExprWalker.setInnerExpression(expression);
                walkingIterator.exprSetParent(UnionPathIterator.this);
                filterExprWalker.exprSetParent(walkingIterator);
                expression.exprSetParent(filterExprWalker);
                expression = walkingIterator;
            } else {
                expression.exprSetParent(UnionPathIterator.this);
            }
            UnionPathIterator.this.m_exprs[this.m_index] = (LocPathIterator)expression;
        }
    }
}

