/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Composite;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import java2d.AnimatingControlsSurface;
import java2d.CustomControls;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FadeAnim
extends AnimatingControlsSurface {
    private static TexturePaint texture;
    private static BasicStroke bs;
    private static Font[] fonts;
    private static String[] strings;
    private static String[] imgs;
    private static Paint[] paints;
    private Vector vector = new Vector(20);
    private int numShapes;
    private int numStrings;
    private int numImages;

    public FadeAnim() {
        this.setBackground(Color.black);
        this.setStrings(2);
        this.setImages(3);
        this.setShapes(8);
        this.setControls(new Component[]{new DemoControls(this)});
        this.setConstraints(new String[]{"East"});
    }

    public void setImages(int n) {
        if (n < this.numImages) {
            Vector vector = new Vector(this.vector.size());
            for (int i = 0; i < this.vector.size(); ++i) {
                if (!(((ObjectData)this.vector.get((int)i)).object instanceof Image)) continue;
                vector.addElement(this.vector.get(i));
            }
            this.vector.removeAll(vector);
            vector.setSize(n);
            this.vector.addAll(vector);
        } else {
            Dimension dimension = this.getSize();
            for (int i = this.numImages; i < n; ++i) {
                Image image = this.getImage(imgs[i % imgs.length]);
                if (imgs[i % imgs.length].equals("jumptojavastrip.png")) {
                    int n2 = image.getWidth(null);
                    int n3 = image.getHeight(null);
                    BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
                    bufferedImage.createGraphics().drawImage(image, 0, 0, null);
                    image = bufferedImage;
                }
                ObjectData objectData = new ObjectData(image, Color.black);
                objectData.reset(dimension.width, dimension.height);
                this.vector.addElement(objectData);
            }
        }
        this.numImages = n;
    }

    public void setStrings(int n) {
        if (n < this.numStrings) {
            Vector vector = new Vector(this.vector.size());
            for (int i = 0; i < this.vector.size(); ++i) {
                if (!(((ObjectData)this.vector.get((int)i)).object instanceof TextData)) continue;
                vector.addElement(this.vector.get(i));
            }
            this.vector.removeAll(vector);
            vector.setSize(n);
            this.vector.addAll(vector);
        } else {
            Dimension dimension = this.getSize();
            for (int i = this.numStrings; i < n; ++i) {
                int n2 = i % fonts.length;
                int n3 = i % strings.length;
                TextData textData = new TextData(strings[n3], fonts[n2], this);
                ObjectData objectData = new ObjectData(textData, paints[i % paints.length]);
                objectData.reset(dimension.width, dimension.height);
                this.vector.addElement(objectData);
            }
        }
        this.numStrings = n;
    }

    public void setShapes(int n) {
        if (n < this.numShapes) {
            Vector vector = new Vector(this.vector.size());
            for (int i = 0; i < this.vector.size(); ++i) {
                if (!(((ObjectData)this.vector.get((int)i)).object instanceof Shape)) continue;
                vector.addElement(this.vector.get(i));
            }
            this.vector.removeAll(vector);
            vector.setSize(n);
            this.vector.addAll(vector);
        } else {
            Dimension dimension = this.getSize();
            for (int i = this.numShapes; i < n; ++i) {
                Shape shape = null;
                switch (i % 7) {
                    case 0: {
                        shape = new GeneralPath();
                        break;
                    }
                    case 1: {
                        shape = new Rectangle2D.Double();
                        break;
                    }
                    case 2: {
                        shape = new Ellipse2D.Double();
                        break;
                    }
                    case 3: {
                        shape = new Arc2D.Double();
                        break;
                    }
                    case 4: {
                        shape = new RoundRectangle2D.Double();
                        break;
                    }
                    case 5: {
                        shape = new CubicCurve2D.Double();
                        break;
                    }
                    case 6: {
                        shape = new QuadCurve2D.Double();
                    }
                }
                ObjectData objectData = new ObjectData(shape, paints[i % paints.length]);
                objectData.reset(dimension.width, dimension.height);
                this.vector.addElement(objectData);
            }
        }
        this.numShapes = n;
    }

    public void reset(int n, int n2) {
        for (int i = 0; i < this.vector.size(); ++i) {
            ((ObjectData)this.vector.get(i)).reset(n, n2);
        }
    }

    public void step(int n, int n2) {
        for (int i = 0; i < this.vector.size(); ++i) {
            ((ObjectData)this.vector.get(i)).step(n, n2);
        }
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        for (int i = 0; i < this.vector.size(); ++i) {
            ObjectData objectData = (ObjectData)this.vector.get(i);
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, objectData.alpha);
            graphics2D.setComposite(alphaComposite);
            graphics2D.setPaint(objectData.paint);
            graphics2D.translate(objectData.x, objectData.y);
            if (objectData.object instanceof Image) {
                graphics2D.drawImage((Image)objectData.object, 0, 0, this);
            } else if (objectData.object instanceof TextData) {
                graphics2D.setFont(((TextData)objectData.object).font);
                graphics2D.drawString(((TextData)objectData.object).string, 0, 0);
            } else if (objectData.object instanceof QuadCurve2D || objectData.object instanceof CubicCurve2D) {
                graphics2D.setStroke(bs);
                graphics2D.draw((Shape)objectData.object);
            } else if (objectData.object instanceof Shape) {
                graphics2D.fill((Shape)objectData.object);
            }
            graphics2D.translate(-objectData.x, -objectData.y);
        }
    }

    public static void main(String[] stringArray) {
        FadeAnim.createDemoFrame(new FadeAnim());
    }

    static {
        int n = 10;
        int n2 = 10;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Color color = Color.blue;
        Color color2 = Color.green;
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color, (float)n * 0.35f, (float)n2 * 0.35f, color2));
        graphics2D.fillRect(0, 0, n / 2, n2 / 2);
        graphics2D.setPaint(new GradientPaint(n, 0.0f, color, (float)n * 0.65f, (float)n2 * 0.35f, color2));
        graphics2D.fillRect(n / 2, 0, n / 2, n2 / 2);
        graphics2D.setPaint(new GradientPaint(0.0f, n2, color, (float)n * 0.35f, (float)n2 * 0.65f, color2));
        graphics2D.fillRect(0, n2 / 2, n / 2, n2 / 2);
        graphics2D.setPaint(new GradientPaint(n, n2, color, (float)n * 0.65f, (float)n2 * 0.65f, color2));
        graphics2D.fillRect(n / 2, n2 / 2, n / 2, n2 / 2);
        texture = new TexturePaint(bufferedImage, new Rectangle(0, 0, n, n2));
        bs = new BasicStroke(6.0f);
        fonts = new Font[]{new Font("Times New Roman", 0, 64), new Font("serif", 3, 24), new Font("Courier", 1, 36), new Font("Arial", 3, 48), new Font("Helvetica", 0, 52)};
        strings = new String[]{"Alpha", "Composite", "Src", "SrcOver", "SrcIn", "SrcOut", "Clear", "DstOver", "DstIn"};
        imgs = new String[]{"jumptojavastrip.png", "duke.gif", "star7.gif"};
        paints = new Paint[]{Color.red, Color.blue, Color.green, Color.magenta, Color.orange, Color.pink, Color.cyan, texture, Color.yellow, Color.lightGray, Color.white};
    }

    static class DemoControls
    extends CustomControls
    implements ChangeListener {
        FadeAnim demo;
        JSlider shapeSlider;
        JSlider stringSlider;
        JSlider imageSlider;
        Font font = new Font("serif", 1, 10);

        public DemoControls(FadeAnim fadeAnim) {
            super(fadeAnim.name);
            this.demo = fadeAnim;
            this.setLayout(new BoxLayout(this, 1));
            this.add(Box.createVerticalStrut(5));
            JToolBar jToolBar = new JToolBar(1);
            jToolBar.setFloatable(false);
            this.shapeSlider = new JSlider(0, 0, 20, fadeAnim.numShapes);
            this.shapeSlider.addChangeListener(this);
            TitledBorder titledBorder = new TitledBorder(new EtchedBorder());
            titledBorder.setTitleFont(this.font);
            titledBorder.setTitle(String.valueOf(fadeAnim.numShapes) + " Shapes");
            this.shapeSlider.setBorder(titledBorder);
            this.shapeSlider.setPreferredSize(new Dimension(80, 45));
            this.shapeSlider.setOpaque(true);
            jToolBar.addSeparator();
            jToolBar.add(this.shapeSlider);
            jToolBar.addSeparator();
            this.stringSlider = new JSlider(0, 0, 10, fadeAnim.numStrings);
            this.stringSlider.addChangeListener(this);
            titledBorder = new TitledBorder(new EtchedBorder());
            titledBorder.setTitleFont(this.font);
            titledBorder.setTitle(String.valueOf(fadeAnim.numStrings) + " Strings");
            this.stringSlider.setBorder(titledBorder);
            this.stringSlider.setPreferredSize(new Dimension(80, 45));
            this.stringSlider.setOpaque(true);
            jToolBar.add(this.stringSlider);
            jToolBar.addSeparator();
            this.imageSlider = new JSlider(0, 0, 10, fadeAnim.numImages);
            this.imageSlider.addChangeListener(this);
            titledBorder = new TitledBorder(new EtchedBorder());
            titledBorder.setTitleFont(this.font);
            titledBorder.setTitle(String.valueOf(fadeAnim.numImages) + " Images");
            this.imageSlider.setBorder(titledBorder);
            this.imageSlider.setPreferredSize(new Dimension(80, 45));
            this.imageSlider.setOpaque(true);
            jToolBar.add(this.imageSlider);
            jToolBar.addSeparator();
            this.add(jToolBar);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            int n = jSlider.getValue();
            TitledBorder titledBorder = (TitledBorder)jSlider.getBorder();
            if (jSlider.equals(this.shapeSlider)) {
                titledBorder.setTitle(String.valueOf(n) + " Shapes");
                this.demo.setShapes(n);
            } else if (jSlider.equals(this.stringSlider)) {
                titledBorder.setTitle(String.valueOf(n) + " Strings");
                this.demo.setStrings(n);
            } else if (jSlider.equals(this.imageSlider)) {
                titledBorder.setTitle(String.valueOf(n) + " Images");
                this.demo.setImages(n);
            }
            jSlider.repaint();
            if (this.demo.animating.thread == null) {
                this.demo.repaint();
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(80, 0);
        }

        public void run() {
            try {
                Thread.sleep(999L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.shapeSlider.setValue((int)(Math.random() * 5.0));
            this.stringSlider.setValue(10);
            this.thread = null;
        }
    }

    static class ObjectData {
        final int UP = 0;
        final int DOWN = 1;
        Object object;
        BufferedImage bimg;
        Paint paint;
        double x;
        double y;
        float alpha;
        int alphaDirection;
        int imgX;

        public ObjectData(Object object, Paint paint) {
            this.object = object;
            this.paint = paint;
            if (object instanceof BufferedImage) {
                this.bimg = (BufferedImage)object;
                this.object = this.bimg.getSubimage(0, 0, 80, 80);
            }
            this.getRandomXY(300, 250);
            this.alpha = (float)Math.random();
            this.alphaDirection = Math.random() > 0.5 ? 0 : 1;
        }

        private void getRandomXY(int n, int n2) {
            if (this.object instanceof TextData) {
                this.x = Math.random() * (double)(n - ((TextData)this.object).width);
                this.y = Math.random() * (double)n2;
                this.y = this.y < (double)((TextData)this.object).height ? (double)((TextData)this.object).height : this.y;
            } else if (this.object instanceof Image) {
                this.x = Math.random() * (double)(n - ((Image)this.object).getWidth(null));
                this.y = Math.random() * (double)(n2 - ((Image)this.object).getHeight(null));
            } else if (this.object instanceof Shape) {
                Rectangle rectangle = ((Shape)this.object).getBounds();
                this.x = Math.random() * (double)(n - rectangle.width);
                this.y = Math.random() * (double)(n2 - rectangle.height);
            }
        }

        public void reset(int n, int n2) {
            this.getRandomXY(n, n2);
            double d = 20.0 + Math.random() * (double)((n == 0 ? 400 : n) / 4);
            double d2 = 20.0 + Math.random() * (double)((n2 == 0 ? 300 : n2) / 4);
            if (this.object instanceof Ellipse2D) {
                ((Ellipse2D)this.object).setFrame(0.0, 0.0, d, d2);
            } else if (this.object instanceof Rectangle2D) {
                ((Rectangle2D)this.object).setRect(0.0, 0.0, d, d);
            } else if (this.object instanceof RoundRectangle2D) {
                ((RoundRectangle2D)this.object).setRoundRect(0.0, 0.0, d2, d2, 20.0, 20.0);
            } else if (this.object instanceof Arc2D) {
                ((Arc2D)this.object).setArc(0.0, 0.0, d2, d2, 45.0, 270.0, 2);
            } else if (this.object instanceof QuadCurve2D) {
                ((QuadCurve2D)this.object).setCurve(0.0, 0.0, (double)n * 0.2, (double)n2 * 0.4, (double)n * 0.4, 0.0);
            } else if (this.object instanceof CubicCurve2D) {
                ((CubicCurve2D)this.object).setCurve(0.0, 0.0, 30.0, -60.0, 60.0, 60.0, 90.0, 0.0);
            } else if (this.object instanceof GeneralPath) {
                GeneralPath generalPath = new GeneralPath();
                float f = (float)d;
                generalPath.moveTo(-f / 2.0f, -f / 8.0f);
                generalPath.lineTo(f / 2.0f, -f / 8.0f);
                generalPath.lineTo(-f / 4.0f, f / 2.0f);
                generalPath.lineTo(0.0f, -f / 2.0f);
                generalPath.lineTo(f / 4.0f, f / 2.0f);
                generalPath.closePath();
                this.object = generalPath;
            }
        }

        public void step(int n, int n2) {
            if (this.object instanceof BufferedImage) {
                if ((this.imgX += 80) == 800) {
                    this.imgX = 0;
                }
                this.object = this.bimg.getSubimage(this.imgX, 0, 80, 80);
            }
            if (this.alphaDirection == 0) {
                float f;
                this.alpha = (float)((double)this.alpha + 0.05);
                if ((double)f > 0.99) {
                    this.alphaDirection = 1;
                    this.alpha = 1.0f;
                }
            } else if (this.alphaDirection == 1) {
                float f;
                this.alpha = (float)((double)this.alpha - 0.05);
                if ((double)f < 0.01) {
                    this.alphaDirection = 0;
                    this.alpha = 0.0f;
                    this.getRandomXY(n, n2);
                }
            }
        }
    }

    static class TextData {
        public String string;
        public Font font;
        public int width;
        public int height;

        public TextData(String string, Font font, Component component) {
            this.string = string;
            this.font = font;
            FontMetrics fontMetrics = component.getFontMetrics(font);
            this.width = fontMetrics.stringWidth(string);
            this.height = fontMetrics.getHeight();
        }
    }
}

