/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetEvent;
import java.util.List;

public class DropTargetDropEvent
extends DropTargetEvent {
    private static final long serialVersionUID = -1721911170440459322L;
    private final int dropAction;
    private final int actions;
    private final Point location;
    private final boolean isLocalTx;

    public DropTargetDropEvent(DropTargetContext dtc, Point location, int dropAction, int actions) {
        this(dtc, location, dropAction, actions, false);
    }

    public DropTargetDropEvent(DropTargetContext dtc, Point location, int dropAction, int actions, boolean isLocalTx) {
        super(dtc);
        if (location == null) {
            throw new NullPointerException();
        }
        if (dtc == null) {
            throw new IllegalArgumentException();
        }
        if (dropAction != 0 && dropAction != 1 && dropAction != 2 && dropAction != 3 && dropAction != 0x40000000 && dropAction != 0x40000000) {
            throw new IllegalArgumentException();
        }
        int actionsMask = 0x40000003;
        if (~(actions ^ actionsMask) != 0) {
            throw new IllegalArgumentException();
        }
        this.dropAction = dropAction;
        this.actions = actions;
        this.location = location;
        this.isLocalTx = isLocalTx;
    }

    public Point getLocation() {
        return this.location;
    }

    public DataFlavor[] getCurrentDataFlavors() {
        return this.context.getCurrentDataFlavors();
    }

    public List getCurrentDataFlavorsAsList() {
        return this.context.getCurrentDataFlavorsAsList();
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.context.isDataFlavorSupported(flavor);
    }

    public int getSourceActions() {
        return this.actions;
    }

    public int getDropAction() {
        return this.dropAction;
    }

    public Transferable getTransferable() {
        return this.context.getTransferable();
    }

    public void acceptDrop(int dropAction) {
        this.context.acceptDrop(dropAction);
    }

    public void rejectDrop() {
        this.context.rejectDrop();
    }

    public void dropComplete(boolean success) {
    }

    public boolean isLocalTransfer() {
        return this.isLocalTx;
    }
}

