/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.rmic;

import gnu.java.rmi.rmic.Compiler;
import gnu.java.rmi.rmic.RMICException;
import java.io.InputStream;

public abstract class CompilerProcess
extends Compiler {
    public abstract String[] computeArguments(String var1);

    public static String[] computeTypicalArguments(String[] compilerArgs, String destination, String filename) {
        int len = compilerArgs.length;
        int arglen = len + (destination == null ? 0 : 2) + 1;
        String[] args = new String[arglen];
        System.arraycopy(compilerArgs, 0, args, 0, len);
        if (destination != null) {
            args[len] = "-d";
            args[len + 1] = destination;
        }
        args[arglen - 1] = filename;
        return args;
    }

    public void compile(String name) throws Exception {
        int result;
        String[] args = this.computeArguments(name);
        Process p = Runtime.getRuntime().exec(args);
        InputStream procin = p.getInputStream();
        int ch = procin.read();
        while (ch != -1) {
            System.out.print((char)ch);
            ch = procin.read();
        }
        StringBuffer stderr = new StringBuffer();
        InputStream procerr = p.getErrorStream();
        int ch2 = procerr.read();
        while (ch2 != -1) {
            stderr.append((char)ch2);
            ch2 = procerr.read();
        }
        while (true) {
            try {
                result = p.waitFor();
            }
            catch (InterruptedException _) {
                continue;
            }
            break;
        }
        if (result != 0) {
            throw new Exception("compiler exited with status: " + result, new RMICException(stderr.toString()));
        }
    }
}

