 /*
  *  copyright (C) 2003-2004
  *  Umbrello UML Modeller Authors <uml-devel@ uml.sf.net>
  */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//qt includes
#include <qpointarray.h>
//kde includes
#include <kcursor.h>
#include <kcolordialog.h>
#include <kdebug.h>
//app includes
#include "umlview.h"
#include "boxwidget.h"

BoxWidget::BoxWidget(UMLView * view, Uml::IDType id) : UMLWidget( view, id ) {
	init();
}

////////////////////////////////////////////////////////////////////////////////////////////////////
void BoxWidget::init() {
	setSize(100,80);
	UMLWidget::setBaseType( Uml::wt_Box );
	setZ(0);
}
////////////////////////////////////////////////////////////////////////////////////////////////////
BoxWidget::~BoxWidget() {

}
////////////////////////////////////////////////////////////////////////////////////////////////////
void BoxWidget::draw(QPainter& p, int offsetX, int offsetY) {
	p.drawRect( offsetX, offsetY, width(), height() );

	if (m_bSelected) {
		drawSelected(&p, offsetX, offsetY, true);
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
void BoxWidget::mouseMoveEvent(QMouseEvent *me) {
	if(!m_bResizing) {
		UMLWidget::mouseMoveEvent(me);
		return;
	}
	if( !m_bMouseDown )
		return;
	int newX = me->x();
	int newY = me->y();
	if (! m_bIgnoreSnapToGrid) {
		newX = m_pView->snappedX( newX );
		newY = m_pView->snappedY( newY );
	}
	int newW = m_nOldW + newX - m_nOldX - m_nPressOffsetX;
	int newH = m_nOldH + newY - m_nOldY - m_nPressOffsetY;
	newW = newW < 20?20:newW;
	newH = newH < 20?20:newH;
	setSize( newW, newH );
	adjustAssocs( getX(), getY() );
}
////////////////////////////////////////////////////////////////////////////////////////////////////
void BoxWidget::mousePressEvent(QMouseEvent *me) {
	UMLWidget::mousePressEvent(me);
	int w = width();
	int h = height();
	m_nOldW = w;
	m_nOldH = h;
	int m = 10;
	//bottomRight
	if( (m_nOldX + m_nPressOffsetX) >= (getX() + width() - m) &&
	    (m_nOldY + m_nPressOffsetY) >= (getY() + height() - m) && me->button() == LeftButton) {
		m_bResizing = true;
		m_pView->setCursor(KCursor::sizeFDiagCursor());
	}
}
////////////////////////////////////////////////////////////////////////////////////////////////////
void BoxWidget::mouseReleaseEvent(QMouseEvent* me) {
	UMLWidget::mouseReleaseEvent(me);
	m_bResizing = false;
	m_pView->setCursor( KCursor::arrowCursor() );
}
////////////////////////////////////////////////////////////////////////////////////////////////////
void BoxWidget::saveToXMI(QDomDocument& qDoc, QDomElement& qElement) {
	QDomElement boxElement = qDoc.createElement("boxwidget");
	UMLWidget::saveToXMI(qDoc, boxElement);
	qElement.appendChild(boxElement);
}

