/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.accessibility.Accessible;
import javax.swing.JComponent;

public class JLayeredPane
extends JComponent
implements Accessible {
    public static String LAYER_PROPERTY = "LAYER_PROPERTY";
    public static Integer FRAME_CONTENT_LAYER = new Integer(-30000);
    public static Integer DEFAULT_LAYER = new Integer(0);
    public static Integer PALETTE_LAYER = new Integer(100);
    public static Integer MODAL_LAYER = new Integer(200);
    public static Integer POPUP_LAYER = new Integer(300);
    public static Integer DRAG_LAYER = new Integer(400);
    TreeMap layers = new TreeMap();
    Hashtable componentToLayer = new Hashtable();

    JLayeredPane() {
    }

    protected Integer getLayer(Component c) {
        if (!this.componentToLayer.containsKey(c)) {
            throw new IllegalArgumentException();
        }
        return (Integer)this.componentToLayer.get(c);
    }

    protected int[] layerToRange(Integer layer) {
        int[] ret = new int[2];
        ret[1] = this.getComponents().length;
        Iterator i = this.layers.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry pair = (Map.Entry)i.next();
            Integer layerNum = (Integer)pair.getKey();
            Integer layerSz = (Integer)pair.getValue();
            if (layerNum == layer) {
                ret[0] = ret[1] - layerSz;
                return ret;
            }
            ret[1] = ret[1] - layerSz;
        }
        throw new IllegalArgumentException();
    }

    protected void incrLayer(Integer layer) {
        int sz = 1;
        if (this.layers.containsKey(layer)) {
            sz += ((Integer)this.layers.get(layer)).intValue();
        }
        this.layers.put(layer, new Integer(sz));
    }

    protected void decrLayer(Integer layer) {
        int sz = 0;
        if (this.layers.containsKey(layer)) {
            sz = (Integer)this.layers.get(layer) - 1;
        }
        this.layers.put(layer, new Integer(sz));
    }

    public int highestLayer() {
        if (this.layers.size() == 0) {
            return 0;
        }
        return (Integer)this.layers.lastKey();
    }

    public int lowestLayer() {
        if (this.layers.size() == 0) {
            return 0;
        }
        return (Integer)this.layers.firstKey();
    }

    public void moveToFront(Component c) {
        this.setPosition(c, 0);
    }

    public void moveToBack(Component c) {
        this.setPosition(c, -1);
    }

    public int getPosition(Component c) {
        Integer layer = this.getLayer(c);
        int[] range = this.layerToRange(layer);
        int top = range[0];
        int bot = range[1];
        Component[] comps = this.getComponents();
        for (int i = top; i < bot; ++i) {
            if (comps[i] != c) continue;
            return i - top;
        }
        throw new IllegalArgumentException();
    }

    public void setPosition(Component c, int position) {
        Integer layer = this.getLayer(c);
        int[] range = this.layerToRange(layer);
        if (range[0] == range[1]) {
            throw new IllegalArgumentException();
        }
        int top = range[0];
        int bot = range[1];
        if (position == -1) {
            position = bot - top - 1;
        }
        int targ = top + position;
        int curr = -1;
        Component[] comps = this.getComponents();
        for (int i = top; i < bot; ++i) {
            if (comps[i] != c) continue;
            curr = i;
            break;
        }
        if (curr == -1) {
            throw new IllegalArgumentException();
        }
        super.swapComponents(curr, targ);
        this.validate();
        this.repaint();
    }

    public Component[] getComponentsInLayer(int layer) {
        int[] range = this.layerToRange(this.getObjectForLayer(layer));
        if (range[0] == range[1]) {
            return new Component[0];
        }
        Component[] comps = this.getComponents();
        int sz = range[1] - range[0];
        Component[] nc = new Component[sz];
        for (int i = 0; i < sz; ++i) {
            nc[i] = comps[range[0] + i];
        }
        return nc;
    }

    public int getComponentCountInLayer(int layer) {
        int[] range = this.layerToRange(this.getObjectForLayer(layer));
        if (range[0] == range[1]) {
            return 0;
        }
        return range[1] - range[0];
    }

    protected Hashtable getComponentToLayer() {
        return this.componentToLayer;
    }

    public int getIndexOf(Component c) {
        Integer layer = this.getLayer(c);
        int[] range = this.layerToRange(layer);
        Component[] comps = this.getComponents();
        for (int i = range[0]; i < range[1]; ++i) {
            if (comps[i] != c) continue;
            return i;
        }
        throw new IllegalArgumentException();
    }

    protected Integer getObjectForLayer(int layer) {
        switch (layer) {
            case -30000: {
                return FRAME_CONTENT_LAYER;
            }
            case 0: {
                return DEFAULT_LAYER;
            }
            case 100: {
                return PALETTE_LAYER;
            }
            case 200: {
                return MODAL_LAYER;
            }
            case 300: {
                return POPUP_LAYER;
            }
            case 400: {
                return DRAG_LAYER;
            }
        }
        return new Integer(layer);
    }

    protected int insertIndexForLayer(int layer, int position) {
        int[] range;
        Integer lobj = this.getObjectForLayer(layer);
        if (!this.layers.containsKey(lobj)) {
            this.layers.put(lobj, new Integer(0));
        }
        if ((range = this.layerToRange(lobj))[0] == range[1]) {
            return range[0];
        }
        int top = range[0];
        int bot = range[1];
        if (position == -1 || position > bot - top) {
            return bot;
        }
        return top + position;
    }

    public void remove(int index) {
        Component c = this.getComponent(index);
        Integer layer = this.getLayer(c);
        this.decrLayer(layer);
        this.componentToLayer.remove(c);
        super.remove(index);
    }

    public void remove(Component comp) {
        this.remove(this.getIndexOf(comp));
    }

    public void setLayer(Component c, int layer) {
        this.componentToLayer.put(c, this.getObjectForLayer(layer));
    }

    public void setLayer(Component c, int layer, int position) {
        this.componentToLayer.put(c, this.getObjectForLayer(layer));
        this.setPosition(c, position);
        this.validate();
        this.repaint();
    }

    protected void addImpl(Component comp, Object layerConstraint, int index) {
        Integer layer = layerConstraint != null && layerConstraint instanceof Integer ? (Integer)layerConstraint : (this.componentToLayer.containsKey(comp) ? (Integer)this.componentToLayer.remove(comp) : DEFAULT_LAYER);
        int newIdx = this.insertIndexForLayer(layer, -1);
        this.componentToLayer.put(comp, layer);
        this.incrLayer(layer);
        super.addImpl(comp, null, newIdx);
        this.validate();
        this.repaint();
    }
}

