/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ListPeer;
import java.util.EventListener;
import java.util.Vector;
import javax.accessibility.Accessible;

public class List
extends Component
implements ItemSelectable,
Accessible {
    private static final long serialVersionUID = -3304312411574666869L;
    private Vector items;
    private boolean multipleMode;
    private int rows;
    private int[] selected;
    private int visibleIndex;
    private ItemListener item_listeners;
    private ActionListener action_listeners;

    private /* synthetic */ void finit$() {
        this.items = new Vector();
    }

    public List() {
        this(4, false);
    }

    public List(int rows) {
        this(rows, false);
    }

    public List(int rows, boolean multipleMode) {
        this.finit$();
        this.rows = rows;
        this.multipleMode = multipleMode;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public int getItemCount() {
        return this.items.size();
    }

    public int countItems() {
        return this.getItemCount();
    }

    public synchronized String[] getItems() {
        Object[] l_items = new String[this.getItemCount()];
        this.items.copyInto(l_items);
        return l_items;
    }

    public String getItem(int index) {
        return (String)this.items.elementAt(index);
    }

    public int getRows() {
        return this.rows;
    }

    public boolean isMultipleMode() {
        return this.multipleMode;
    }

    public boolean allowsMultipleSelections() {
        return this.multipleMode;
    }

    public void setMultipleMode(boolean multipleMode) {
        this.multipleMode = multipleMode;
        if (this.peer != null) {
            ListPeer l = (ListPeer)this.peer;
            l.setMultipleMode(multipleMode);
        }
    }

    public void setMultipleSelections(boolean multipleMode) {
        this.setMultipleMode(multipleMode);
    }

    public Dimension getMinimumSize() {
        return this.getMinimumSize(this.rows);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize(this.rows);
    }

    public Dimension getMinimumSize(int rows) {
        ListPeer lp = (ListPeer)this.getPeer();
        if (lp != null) {
            return lp.minimumSize(rows);
        }
        return new Dimension(0, 0);
    }

    public Dimension minimumSize(int rows) {
        return this.getMinimumSize(rows);
    }

    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.rows);
    }

    public Dimension preferredSize() {
        return this.getPreferredSize(this.rows);
    }

    public Dimension getPreferredSize(int rows) {
        ListPeer lp = (ListPeer)this.getPeer();
        if (lp != null) {
            return lp.preferredSize(rows);
        }
        return new Dimension(0, 0);
    }

    public Dimension preferredSize(int rows) {
        return this.getPreferredSize(rows);
    }

    public void add(String item) {
        this.add(item, -1);
    }

    public void addItem(String item) {
        this.addItem(item, -1);
    }

    public void add(String item, int index) {
        if (index == -1 || index >= this.items.size()) {
            this.items.addElement(item);
        } else {
            this.items.insertElementAt(item, index);
        }
        if (this.peer != null) {
            ListPeer l = (ListPeer)this.peer;
            l.add(item, index);
        }
    }

    public void addItem(String item, int index) {
        this.add(item, index);
    }

    public void delItem(int index) throws IllegalArgumentException {
        this.remove(index);
    }

    public void remove(int index) throws IllegalArgumentException {
        this.items.removeElementAt(index);
        if (this.peer != null) {
            ListPeer l = (ListPeer)this.peer;
            l.delItems(index, index);
        }
    }

    public synchronized void delItems(int start, int end) throws IllegalArgumentException {
        if (start < 0 || start >= this.items.size()) {
            throw new IllegalArgumentException("Bad list start index value: " + start);
        }
        if (start < 0 || start >= this.items.size()) {
            throw new IllegalArgumentException("Bad list start index value: " + start);
        }
        if (start > end) {
            throw new IllegalArgumentException("Start is greater than end!");
        }
        for (int i = end; i >= start; --i) {
            this.items.removeElementAt(i);
        }
        if (this.peer != null) {
            ListPeer l = (ListPeer)this.peer;
            l.delItems(start, end);
        }
    }

    public synchronized void remove(String item) throws IllegalArgumentException {
        int index = this.items.indexOf(item);
        if (index == -1) {
            throw new IllegalArgumentException("List element to delete not found");
        }
        this.remove(index);
    }

    public synchronized void removeAll() {
        this.items.clear();
        if (this.peer != null) {
            ListPeer l = (ListPeer)this.peer;
            l.removeAll();
        }
    }

    public void clear() {
        this.removeAll();
    }

    public synchronized void replaceItem(String item, int index) throws IllegalArgumentException {
        if (index < 0 || index >= this.items.size()) {
            throw new IllegalArgumentException("Bad list index: " + index);
        }
        this.items.insertElementAt(item, index + 1);
        this.items.removeElementAt(index);
        if (this.peer != null) {
            ListPeer l = (ListPeer)this.peer;
            l.add(item, index + 1);
            l.delItems(index, index);
        }
    }

    public synchronized int getSelectedIndex() {
        if (this.peer != null) {
            ListPeer l = (ListPeer)this.peer;
            this.selected = l.getSelectedIndexes();
        }
        if (this.selected == null || this.selected.length != 1) {
            return -1;
        }
        return this.selected[0];
    }

    public synchronized int[] getSelectedIndexes() {
        if (this.peer != null) {
            ListPeer l = (ListPeer)this.peer;
            this.selected = l.getSelectedIndexes();
        }
        return this.selected;
    }

    public synchronized String getSelectedItem() {
        int index = this.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return (String)this.items.elementAt(index);
    }

    public synchronized String[] getSelectedItems() {
        int[] indexes = this.getSelectedIndexes();
        if (indexes == null) {
            return new String[0];
        }
        String[] retvals = new String[indexes.length];
        if (retvals.length > 0) {
            for (int i = 0; i < retvals.length; ++i) {
                retvals[i] = (String)this.items.elementAt(indexes[i]);
            }
        }
        return retvals;
    }

    public synchronized Object[] getSelectedObjects() {
        int[] indexes = this.getSelectedIndexes();
        if (indexes == null) {
            return new Object[0];
        }
        Object[] retvals = new Object[indexes.length];
        if (retvals.length > 0) {
            for (int i = 0; i < retvals.length; ++i) {
                retvals[i] = this.items.elementAt(indexes[i]);
            }
        }
        return retvals;
    }

    public boolean isIndexSelected(int index) {
        int[] indexes = this.getSelectedIndexes();
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] != index) continue;
            return true;
        }
        return false;
    }

    public boolean isSelected(int index) {
        return this.isIndexSelected(index);
    }

    public synchronized void makeVisible(int index) throws IllegalArgumentException {
        if (index < 0 || index >= this.items.size()) {
            throw new IllegalArgumentException("Bad list index: " + index);
        }
        this.visibleIndex = index;
        if (this.peer != null) {
            ListPeer l = (ListPeer)this.peer;
            l.makeVisible(index);
        }
    }

    public int getVisibleIndex() {
        return this.visibleIndex;
    }

    public synchronized void select(int index) {
        ListPeer lp = (ListPeer)this.getPeer();
        if (lp != null) {
            lp.select(index);
        }
    }

    public synchronized void deselect(int index) {
        ListPeer lp = (ListPeer)this.getPeer();
        if (lp != null) {
            lp.deselect(index);
        }
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createList(this);
        }
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
    }

    public synchronized void addActionListener(ActionListener listener) {
        this.action_listeners = AWTEventMulticaster.add(this.action_listeners, listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.action_listeners = AWTEventMulticaster.remove(this.action_listeners, listener);
    }

    public synchronized void addItemListener(ItemListener listener) {
        this.item_listeners = AWTEventMulticaster.add(this.item_listeners, listener);
    }

    public synchronized void removeItemListener(ItemListener listener) {
        this.item_listeners = AWTEventMulticaster.remove(this.item_listeners, listener);
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)event);
        } else if (event instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processActionEvent(ActionEvent event) {
        if (this.action_listeners != null) {
            this.action_listeners.actionPerformed(event);
        }
    }

    protected void processItemEvent(ItemEvent event) {
        if (this.item_listeners != null) {
            this.item_listeners.itemStateChanged(event);
        }
    }

    void dispatchEventImpl(AWTEvent e) {
        if (e.id <= 701 && e.id >= 701 && (this.item_listeners != null || (this.eventMask & (long)512) != 0L)) {
            this.processEvent(e);
        } else if (e.id <= 1001 && e.id >= 1001 && (this.action_listeners != null || (this.eventMask & (long)128) != 0L)) {
            this.processEvent(e);
        } else {
            super.dispatchEventImpl(e);
        }
    }

    protected String paramString() {
        return "multiple=" + this.multipleMode + ",rows=" + this.rows + super.paramString();
    }

    public EventListener[] getListeners(Class listenerType) {
        if (listenerType == List.class$("java.awt.event.ActionListener")) {
            return AWTEventMulticaster.getListeners(this.action_listeners, listenerType);
        }
        if (listenerType == List.class$("java.awt.event.ItemListener")) {
            return AWTEventMulticaster.getListeners(this.item_listeners, listenerType);
        }
        return super.getListeners(listenerType);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(List.class$("java.awt.event.ActionListener"));
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(List.class$("java.awt.event.ItemListener"));
    }
}

