/* 
 * Copyright (C) 2003 the xine project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: drag_drop.c,v 1.5 2004/11/10 01:29:12 dsalt Exp $
 *
 * drag and drop support for the main window
 */

#include "globals.h"

#include <gtk/gtk.h>
#include <stdio.h>

#include "drag_drop.h"
#include "playlist.h"

/*
#define LOG
*/

static void drag_cb (GtkWidget          *widget,
		     GdkDragContext     *context,
		     gint                x,
		     gint                y,
		     GtkSelectionData   *data,
		     guint               info,
		     guint               time) {

  logprintf ("drag_drop: drag callback, length=%d, format=%d\n",
	     data->length, data->format);

  if (data->format == 8) {

    gint  i, len, first;
    gchar str[MAX_MRL_LEN];
    
    len = 0; i = 0; first = -1;

    while (i<data->length) {

      char c;

      c = data->data[i];

      if ( (len<(MAX_MRL_LEN-1)) 
	   && (c != '\r') 
	   && (c != '\n') ) {
	str[len] = c;
	len++;
      } else if (c=='\r') {

	str[len] = 0;

	if (first<0)
	  first = playlist_add_mrl (str, -1);
	else
	  playlist_add_mrl (str, -1);

	len = 0;

      } 
      i++;
    }
    
    if (first>=0)
      playlist_play (first);
  }

  gtk_drag_finish (context, TRUE, FALSE, time);
}

static const GtkTargetEntry target_table[] = {
        { "text/uri-list", 0, 0 },
};

void drag_drop_setup (GtkWidget *widget) {

  gtk_drag_dest_set (widget, GTK_DEST_DEFAULT_ALL,
		     target_table, 1, GDK_ACTION_COPY);

  g_signal_connect (GTK_OBJECT (widget), "drag_data_received",
		    G_CALLBACK (drag_cb), NULL);
}
