/*
 * system dependent wrapper for access to cdrom
 * Copyright (C) 1999  Martin Vogt
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation.
 *
 *  For more information look at the file COPYRIGHT in this package
 *
 * $Id: cdromAccess.cpp,v 1.9 2004/05/11 16:32:08 cartman Exp $
 *
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif



#ifdef OS_AIX 
  #include "cdromAccess_Empty.cpp"
#endif

#ifdef OS_Linux
  #include <linux/version.h>
  #include <sys/types.h>
  #ifndef __u64
  #if LINUX_VERSION_CODE >= KERNEL_VERSION(2,5,70)
  typedef unsigned long long __u64;
  #endif
  #endif
  #include "cdromAccess_Linux.cpp"
#endif

#ifdef OS_BSD
  #include "cdromAccess_Empty.cpp"
#endif

#if defined(OS_IRIX) || defined(OS_IRIX64)
  #include "cdromAccess_Empty.cpp"
#endif

#ifdef OS_HPUX
  #include "cdromAccess_Empty.cpp"
#endif

#ifdef OS_SunOS
  #include "cdromAccess_Empty.cpp"
#endif

#ifdef __BEOS__
  #include "cdromAccess_Empty.cpp"
#endif

#ifdef WIN32
  #include "cdromAccess_Empty.cpp"
#endif


