/* ****************************************************************************
  This file is part of KMathTool

  Copyright (C) 2003 by Marco Wegner <mail@marcowegner.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */


#ifndef KMTVALIDATOR_H
#define KMTVALIDATOR_H

#include <qvalidator.h>


class PointValidator : public QValidator
{
  Q_OBJECT

  public:
    enum Size { TwoD = 2, ThreeD = 3 };

    PointValidator(QObject* parent, const char* name = 0);
    PointValidator(Size size, QObject* parent, const char* name = 0);
    virtual ~PointValidator( );

    virtual QValidator::State validate(QString& input, int& pos);

  private:
    Size s;
};

#endif // KMTPOINTVALIDATOR_H
