/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* callbacks_printdialog.c
 *
 * This is where the callbacks for the print dialog resides. 
 * For callbacks related to the widgets in the main window, see the files
 * called callbacks_<widgetname>.[c|h].
 */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <string.h>
#include <gtk/gtk.h>
#include <libgnomeprint/gnome-print.h>
#include <libgnomeprint/gnome-print-job.h>

#include "support.h"
#include "types.h"
#include "log.h"
#include "utils.h"
#include "callbacks_printdialog.h"

extern GtkWidget *mainwindow;
extern GtkWidget *mainnotebook;
extern gchar *xlogdir;
extern preferencestype preferences;
extern GtkWidget *printdialog;
extern GList *logwindowlist;

#define LEFTMARGIN	40
#define BOTTOMMARGIN	40
#define TOPMARGIN		60

/* calculate number of characters in a column for the next 30 or 50 QSO's */
gint 
colwidth (gpointer arg, gint column, gint firstqso, gint printorientation)
{
	GtkTreeIter iter;
	GtkTreeModel *model;
	GtkTreePath *path;
	gint i, lastqso, width = 0;
	gchar *pathstr, *it;
	logtype *logwindow = (logtype *) arg;

	if (printorientation == 1)
		lastqso = firstqso - 30;
	else
		lastqso = firstqso - 50;
	if (lastqso < 0)
		lastqso = 0;

	/* make sure the header fits */
	if (column == NR)
		width = strlen ("Nr");
	else if (column == DATE)
		width = strlen ("Date");
	else if (column == GMT)
		width = strlen ("GMT");
	else if (column == GMTEND)
		width = strlen ("END");
	else if (column == CALL)
		width = strlen ("Callsign");
	else if (column == BAND)
		width = strlen ("MHz");
	else if (column == MODE)
		width = strlen ("Mode");
	else if (column == RST)
		width = strlen ("TX");
	else if (column == MYRST)
		width = strlen ("RX");
	else if (column == QSLOUT)
		width = strlen ("Out");
	else if (column == QSLIN)
		width = strlen ("In");
	else if (column == POWER)
		width = strlen ("Pwr");
	else if (column == NAME)
		width = strlen ("Name");
	else if (column == QTH)
		width = strlen ("QTH");
	else if (column == LOCATOR)
		width = strlen ("Locator");
	else if (column == U1)
		width = strlen (preferences.freefield1);
	else if (column == U2)
		width = strlen (preferences.freefield1);
	else if (column == REMARKS)
		width = strlen ("Remarks");
	else
		width = 4;

	model = gtk_tree_view_get_model (GTK_TREE_VIEW(logwindow->treeview));
	for (i = firstqso; i >= lastqso; i--)
	{
		pathstr = g_strdup_printf("%d", i);
		path = gtk_tree_path_new_from_string (pathstr);
		gtk_tree_model_get_iter (model, &iter, path);
		gtk_tree_model_get (model, &iter, column, &it, -1);
		width = strlen (it) > width ? strlen (it) : width;
		g_free (pathstr);
	}
	return width;
}

void
on_printokbutton_clicked (GtkButton * button, gpointer user_data)
{
	GtkWidget *printallradiobutton, *printrangeradiobutton, *printlowentry,
		*printhighentry, *sizecomboentry, *pointcomboentry, *orientationcomboentry,
		*filedestinationradiobutton, *printerdestinationradiobutton, 
		*contestcheckbutton;
	GtkWidget *p1, *p2, *p3, *p4, *p5, *p6, *p7, *p8, *p9, *p10,
		*p11, *p12, *p13, *p14, *p15, *p16, *p17, *p18;
	gboolean nrok = FALSE, dateok = FALSE, gmtok = FALSE, gmtendok = FALSE, 
		callok = FALSE, bandok = FALSE, modeok = FALSE, rstok = FALSE, 
		myrstok = FALSE, qsloutok = FALSE, qslinok = FALSE, powerok = FALSE, 
		nameok = FALSE, qthok = FALSE, locatorok = FALSE, u1ok = FALSE,
		u2ok = FALSE, remarksok = FALSE;
	gchar *temp, *fontsize, *papersize, *psfile, **item, *pathstr;
	gint i, j, k = 0, printhigh, printlow;
	gint wnr = 100, wdate = 100, wgmt = 100, wgmtend = 100, wcall = 100, wband = 100,
		wmode = 100, wrst = 100, wmyrst = 100, wqslout = 100,	wqslin = 100, wpower = 100,
		wname = 100, wqth = 100, wlocator = 100, wu1 = 100, wu2 = 100, wremarks = 100;
	double left, top, saved, pwidth, pheight, fheight, fwidth;
	gboolean contest;
	logtype *logwindow;
	GtkTreeIter iter;
	GtkTreeModel *model;
	GtkTreePath *path;
	GnomePrintJob *job;
	GnomePrintContext *gpc;
	GnomePrintConfig *config;
	GnomeFont *font = NULL, *bfont = NULL, *ifont = NULL;

	printallradiobutton = lookup_widget (printdialog, "printallradiobutton");
	printrangeradiobutton =
		lookup_widget (printdialog, "printrangeradiobutton");
	printlowentry = lookup_widget (printdialog, "printlowentry");
	printhighentry = lookup_widget (printdialog, "printhighentry");
	sizecomboentry = lookup_widget (printdialog, "sizecomboentry");
	pointcomboentry = lookup_widget (printdialog, "pointcomboentry");
	filedestinationradiobutton = 
		lookup_widget (printdialog, "filedestinationradiobutton");
	printerdestinationradiobutton = 
		lookup_widget (printdialog, "printerdestinationradiobutton");
	orientationcomboentry = lookup_widget (printdialog, "orientationcomboentry");
	contestcheckbutton = lookup_widget (printdialog, "contestcheckbutton");

	/* toggle buttons */
	p1 = lookup_widget (printdialog, "p1");
	p2 = lookup_widget (printdialog, "p2");
	p3 = lookup_widget (printdialog, "p3");
	p4 = lookup_widget (printdialog, "p4");
	p5 = lookup_widget (printdialog, "p5");
	p6 = lookup_widget (printdialog, "p6");
	p7 = lookup_widget (printdialog, "p7");
	p8 = lookup_widget (printdialog, "p8");
	p9 = lookup_widget (printdialog, "p9");
	p10 = lookup_widget (printdialog, "p10");
	p11 = lookup_widget (printdialog, "p11");
	p12 = lookup_widget (printdialog, "p12");
	p13 = lookup_widget (printdialog, "p13");
	p14 = lookup_widget (printdialog, "p14");
	p15 = lookup_widget (printdialog, "p15");
	p16 = lookup_widget (printdialog, "p16");
	p17 = lookup_widget (printdialog, "p17");
	p18 = lookup_widget (printdialog, "p18");
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p1))) 
		nrok = TRUE;
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p2))) 
		dateok = TRUE;
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p3))) 
		gmtok = TRUE;
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p4))) 
		gmtendok = TRUE;
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p5))) 
		callok = TRUE;
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p6))) 
		bandok = TRUE;
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p7))) 
		modeok = TRUE;
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p8))) 
		rstok = TRUE;
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p9))) 
		myrstok = TRUE;
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p10))) 
		qsloutok = TRUE;
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p11))) 
		qslinok = TRUE;
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p12))) 
		powerok = TRUE;
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p13))) 
		nameok = TRUE;
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p14))) 
		qthok = TRUE;
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p15))) 
		locatorok = TRUE;
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p16))) 
		u1ok = TRUE;
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p17))) 
		u2ok = TRUE;
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p18))) 
		remarksok = TRUE;
	
	if (!nrok && !dateok && !gmtok && !gmtendok && !callok && !bandok && !modeok 
		&& !rstok && !myrstok && !qsloutok && !qslinok && !powerok && !nameok 
		&& !qthok && !locatorok && !u1ok && !u2ok && !remarksok)
	{
		update_statusbar (_("No columns selected, printing cancelled..."));
		gtk_widget_set_sensitive (mainwindow, 1);
		gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET (button)));
		return;
	}

	/* save settings of the print dialog */
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (printallradiobutton)))
		preferences.printall = 0;
	else
		preferences.printall = 1;

	temp = gtk_editable_get_chars (GTK_EDITABLE (printlowentry), 0, -1);
	printlow = atoi (temp);
	temp = gtk_editable_get_chars (GTK_EDITABLE (printhighentry), 0, -1);
	printhigh = atoi (temp);
	temp = gtk_editable_get_chars (GTK_EDITABLE (sizecomboentry), 0, -1);

	if (g_ascii_strcasecmp (temp, "a4") == 0)
		preferences.printsize = 0;
	else
		preferences.printsize = 1;

	temp = gtk_editable_get_chars (GTK_EDITABLE (pointcomboentry), 0, -1);
	if (g_ascii_strcasecmp (temp, "10") == 0)
		preferences.printpoint = 0;
	else if (g_ascii_strcasecmp (temp, "11") == 0)
		preferences.printpoint = 1;
	else if (g_ascii_strcasecmp (temp, "12") == 0)
		preferences.printpoint = 2;
	else if (g_ascii_strcasecmp (temp, "13") == 0)
		preferences.printpoint = 3;
	else if (g_ascii_strcasecmp (temp, "14") == 0)
		preferences.printpoint = 4;
	else if (g_ascii_strcasecmp (temp, "6") == 0)
		preferences.printpoint = 5;
	else if (g_ascii_strcasecmp (temp, "7") == 0)
		preferences.printpoint = 6;
	else if (g_ascii_strcasecmp (temp, "8") == 0)
		preferences.printpoint = 7;
	else
		preferences.printpoint = 8;

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON (printerdestinationradiobutton)))
		preferences.printdestination = 0;
	else
		preferences.printdestination = 1;

	temp = gtk_editable_get_chars (GTK_EDITABLE (orientationcomboentry), 0, -1);
	if (g_ascii_strcasecmp (temp, _("portrait")) == 0)
		preferences.printorientation = 0;
	else
		preferences.printorientation = 1;

	if (preferences.printsize == 0)
		papersize = g_strdup ("A4");
	else
		papersize = g_strdup ("USLetter");

	if (preferences.printpoint == 0)
		fontsize = g_strdup ("10");
	else if (preferences.printpoint == 1)
		fontsize = g_strdup ("11");
	else if (preferences.printpoint == 2)
		fontsize = g_strdup ("12");
	else if (preferences.printpoint == 3)
		fontsize = g_strdup ("13");
	else if (preferences.printpoint == 4)
		fontsize = g_strdup ("14");
	else if (preferences.printpoint == 5)
		fontsize = g_strdup ("6");
	else if (preferences.printpoint == 6)
		fontsize = g_strdup ("7");
	else if (preferences.printpoint == 7)
		fontsize = g_strdup ("8");
	else if (preferences.printpoint == 8)
		fontsize = g_strdup ("9");
	else
		fontsize = g_strdup ("10");

	contest = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(contestcheckbutton));

	logwindow = g_list_nth_data (logwindowlist,	gtk_notebook_get_current_page (GTK_NOTEBOOK(mainnotebook)));
	item = g_new0 (gchar *, QSO_FIELDS);

	/* configure printing */
	job = gnome_print_job_new (NULL);
	config = gnome_print_job_get_config (job);
	gnome_print_config_set (config, "Printer", "GENERIC");
	gnome_print_config_set (config, GNOME_PRINT_KEY_PAPER_SIZE, papersize);
	/* page size needed to calculate text position */
	psfile = g_strconcat (xlogdir, G_DIR_SEPARATOR_S, "log.ps", NULL);
	if (preferences.printdestination == 1)
		gnome_print_job_print_to_file (job, psfile);
	/* libgnomeprint fallback does not work for me */
	font = gnome_font_find_closest ("Sans Regular", atoi(fontsize));
	if (!font)
		font = gnome_font_find_closest ("Serif Regular", atoi(fontsize));
	if (!font)
		font = gnome_font_find_closest ("Helvetica", atoi(fontsize));
	if (!font)
		font = gnome_font_find_closest ("Times", atoi(fontsize));
	if (!font)
		font = gnome_font_find_closest ("Sans Regular", atoi(fontsize));

	/* font width and height needed to calculate text position */
	gpc = gnome_print_job_get_context (job);
	gnome_print_config_get_page_size (config, &pwidth, &pheight);
	if (font)
	{
		fheight = gnome_font_get_ascender (font) + gnome_font_get_descender (font);
		fwidth = gnome_font_get_width_utf8 (font, "#");
	}
	else
	{
		fheight = atoi (fontsize);
		fwidth = fheight * 0.8;
	}

	bfont = gnome_font_find_closest ("Sans Bold", atoi (fontsize));
	ifont = gnome_font_find_closest ("Sans Italic", atoi (fontsize));

	if (preferences.printall == 0)
	{
		printlow = 1;
		printhigh = logwindow->qsos;
	}

	model = gtk_tree_view_get_model (GTK_TREE_VIEW (logwindow->treeview));
	if (gtk_tree_model_get_iter_first (model, &iter))
	{
		temp = g_strdup_printf (_("Printing to %s%slog.ps"), xlogdir, G_DIR_SEPARATOR_S);
		update_statusbar (temp);

		for (i = logwindow->qsos - printlow; i >= logwindow->qsos - printhigh; i--)
		{
			left = LEFTMARGIN;
			/* calculate position of every line in the log */
			if (preferences.printorientation == 1)
				top = pwidth - TOPMARGIN - ((k % 30) * ((pwidth - 1.5 * TOPMARGIN) / 30));
			else
				top = pheight - TOPMARGIN - ((k % 50) * ((pheight - 1.5 * TOPMARGIN) / 50));

			if ((k % 30 == 0 && preferences.printorientation == 1) /* landscape */
				|| (k % 50 == 0 && preferences.printorientation == 0)) /* portrait */
			{
				gnome_print_beginpage (gpc, "");
				gnome_print_setfont (gpc, font);
				if (preferences.printorientation == 1) /* landscape */
				{
					gnome_print_config_get_page_size (config, &pwidth, &pheight);
					gnome_print_rotate (gpc, 90);
					gnome_print_translate (gpc, 0, -pwidth);
				}
				saved = top;
				top = top + 3 * fheight;
				/* print header and calculate widths */
				if (bfont) 
					gnome_print_setfont (gpc, bfont);
				if (nrok) 
				{
					gnome_print_moveto (gpc, left, top);
					gnome_print_show (gpc, "Nr");
					wnr = colwidth (logwindow, NR, i, preferences.printorientation);
					left = left + 0.5 + wnr * fwidth;
				}
				if (dateok) 
				{
					gnome_print_moveto (gpc, left, top);
					gnome_print_show (gpc, "Date");
					wdate = colwidth (logwindow, DATE, i, preferences.printorientation);
					left = left + 0.5 + wdate * fwidth;
				}
				if (gmtok) 
				{
					gnome_print_moveto (gpc, left, top);
					gnome_print_show (gpc, "GMT");
					wgmt = colwidth (logwindow, GMT, i, preferences.printorientation);
					left = left + 0.5 + wgmt * fwidth;
				}
				if (gmtendok) 
				{
					gnome_print_moveto (gpc, left, top);
					gnome_print_show (gpc, "END");
					wgmtend = colwidth (logwindow, GMTEND, i, preferences.printorientation);
					left = left + 0.5 + wgmtend * fwidth;
				}
				if (callok) 
				{
					gnome_print_moveto (gpc, left, top);
					gnome_print_show (gpc, "Callsign");
					wcall = colwidth (logwindow, CALL, i, preferences.printorientation);
					left = left + 0.5 + wcall * fwidth;
				}
				if (bandok) 
				{
					gnome_print_moveto (gpc, left, top);
					gnome_print_show (gpc, "MHz");
					wband = colwidth (logwindow, BAND, i, preferences.printorientation);
					left = left + 0.5 + wband * fwidth;
				}
				if (modeok) 
				{
					gnome_print_moveto (gpc, left, top);
					gnome_print_show (gpc, "Mode");
					wmode = colwidth (logwindow, MODE, i, preferences.printorientation);
					left = left + 0.5 + wmode * fwidth;
				}
				if (rstok) 
				{
					gnome_print_moveto (gpc, left, top);
					gnome_print_show (gpc, "TX");
					wrst = colwidth (logwindow, RST, i, preferences.printorientation);
					left = left + 0.5 + wrst * fwidth;
				}
				if (myrstok) 
				{
					gnome_print_moveto (gpc, left, top);
					gnome_print_show (gpc, "RX");
					wmyrst = colwidth (logwindow, MYRST, i, preferences.printorientation);
					left = left + 0.5 + wmyrst * fwidth;
				}
				if (qsloutok) 
				{
					gnome_print_moveto (gpc, left, top);
					gnome_print_show (gpc, "Out");
					wqslout = colwidth (logwindow, QSLOUT, i, preferences.printorientation);
					left = left + 0.5 + wqslout * fwidth;
				}
				if (qslinok) 
				{
					gnome_print_moveto (gpc, left, top);
					gnome_print_show (gpc, "In");
					wqslin = colwidth (logwindow, QSLIN, i, preferences.printorientation);
					left = left + 0.5 + wqslin * fwidth;
				}
				if (powerok) 
				{
					gnome_print_moveto (gpc, left, top);
					gnome_print_show (gpc, "Pwr");
					wpower = colwidth (logwindow, POWER, i, preferences.printorientation);
					left = left + 0.5 + wpower * fwidth;
				}
				if (nameok) 
				{
					gnome_print_moveto (gpc, left, top);
					gnome_print_show (gpc, "Name");
					wname = colwidth (logwindow, NAME, i, preferences.printorientation);
					left = left + 0.5 + wname * fwidth;
				}
				if (qthok) 
				{
					gnome_print_moveto (gpc, left, top);
					gnome_print_show (gpc, "QTH");
					wqth = colwidth (logwindow, QTH, i, preferences.printorientation);
					left = left + 0.5 + wqth * fwidth;
				}
				if (locatorok) 
				{
					gnome_print_moveto (gpc, left, top);
					gnome_print_show (gpc, "Locator");
					wlocator = colwidth (logwindow, LOCATOR, i, preferences.printorientation);
					left = left + 0.5 + wlocator * fwidth;
				}
				if (u1ok)
				{
					gnome_print_moveto (gpc, left, top);
					gnome_print_show (gpc, preferences.freefield1);
					wu1 = colwidth (logwindow, U1, i, preferences.printorientation);
					left = left + 0.5 + wu1 * fwidth;
				}
				if (u2ok) 
				{
					gnome_print_moveto (gpc, left, top);
					gnome_print_show (gpc, preferences.freefield2);
					wu2 = colwidth (logwindow, U2, i, preferences.printorientation);
					left = left + 0.5 + wu2 * fwidth;
				}
				if (remarksok) 
				{
					gnome_print_moveto (gpc, left, top);
					gnome_print_show (gpc, "Remarks");
					wremarks = colwidth (logwindow, REMARKS, i, preferences.printorientation);
					left = left + 0.5 + wremarks * fwidth;
				}
				if (contest)
				{
					gnome_print_moveto (gpc, left, top);
					gnome_print_show (gpc, "Mult");
					left = left + 0.5 + 4 * fwidth;
					gnome_print_moveto (gpc, left, top);
					gnome_print_show (gpc, "Points");
				}
				top = top - fheight;
				left = LEFTMARGIN;
				gnome_print_moveto (gpc, left, top);
				if (preferences.printorientation == 1)
					gnome_print_lineto (gpc, left + pheight - 2 * LEFTMARGIN, top);				
				else
					gnome_print_lineto (gpc, left + pwidth - 2 * LEFTMARGIN, top);				
				gnome_print_stroke (gpc);
				top = saved;
			} /* end of header */
			
			/* QSO's to print */
			if (font) 
				gnome_print_setfont (gpc, font);
			left = LEFTMARGIN;
			pathstr = g_strdup_printf("%d", i);
 			path = gtk_tree_path_new_from_string (pathstr);
 			gtk_tree_model_get_iter (model, &iter, path);
			for (j = 0; j < QSO_FIELDS; j++)
				gtk_tree_model_get (model, &iter, j, &item[j], -1);
			if (nrok) 
			{
				gnome_print_moveto (gpc, left, top);
				gnome_print_show (gpc, item[NR]);
				left = left + 0.5 + wnr * fwidth;
			}
			if (dateok) 
			{
				gnome_print_moveto (gpc, left, top);
				gnome_print_show (gpc, item[DATE]);
				left = left + 0.5 + wdate * fwidth;
			}
			if (gmtok) 
			{
				gnome_print_moveto (gpc, left, top);
				gnome_print_show (gpc, item[GMT]);
				left = left + 0.5 + wgmt * fwidth;
			}
			if (gmtendok) 
			{
				gnome_print_moveto (gpc, left, top);
				gnome_print_show (gpc, item[GMTEND]);
				left = left + 0.5 + wgmtend * fwidth;
			}
			if (callok) 
			{
				if (bfont) 
					gnome_print_setfont (gpc, bfont);
				gnome_print_moveto (gpc, left, top);
				gnome_print_show (gpc, item[CALL]);
				left = left + 0.5 + wcall * fwidth;
				if (font) 
					gnome_print_setfont (gpc, font);
			}
			if (bandok) 
			{
				gnome_print_moveto (gpc, left, top);
				gnome_print_show (gpc, item[BAND]);
				left = left + 0.5 + wband * fwidth;
			}
			if (modeok) 
			{
				gnome_print_moveto (gpc, left, top);
				gnome_print_show (gpc, item[MODE]);
				left = left + 0.5 + wmode * fwidth;
			}
			if (rstok) 
			{
				gnome_print_moveto (gpc, left, top);
				gnome_print_show (gpc, item[RST]);
				left = left + 0.5 + wrst * fwidth;
			}
			if (myrstok) 
			{
				gnome_print_moveto (gpc, left, top);
				gnome_print_show (gpc, item[MYRST]);
				left = left + 0.5 + wmyrst * fwidth;
			}
			if (qsloutok) 
			{
				gnome_print_moveto (gpc, left, top);
				gnome_print_show (gpc, item[QSLOUT]);
				left = left + 0.5 + wqslout * fwidth;
			}
			if (qslinok) 
			{
				gnome_print_moveto (gpc, left, top);
				gnome_print_show (gpc, item[QSLIN]);
				left = left + 0.5 + wqslin * fwidth;
			}
			if (powerok) 
			{
				gnome_print_moveto (gpc, left, top);
				gnome_print_show (gpc, item[POWER]);
				left = left + 0.5 + wpower * fwidth;
			}
			if (nameok) 
			{
				gnome_print_moveto (gpc, left, top);
				gnome_print_show (gpc, item[NAME]);
				left = left + 0.5 + wname * fwidth;
			}
			if (qthok) 
			{
				gnome_print_moveto (gpc, left, top);
				gnome_print_show (gpc, item[QTH]);
				left = left + 0.5 + wqth * fwidth;
			}
			if (locatorok) 
			{
				gnome_print_moveto (gpc, left, top);
				gnome_print_show (gpc, item[LOCATOR]);
				left = left + 0.5 + wlocator * fwidth;
			}
			if (u1ok) 
			{
				gnome_print_moveto (gpc, left, top);
				gnome_print_show (gpc, item[U1]);
				left = left + 0.5 + wu1 * fwidth;
			}
			if (u2ok) 
			{
				gnome_print_moveto (gpc, left, top);
				gnome_print_show (gpc, item[U2]);
				left = left + 0.5 + wu2 * fwidth;
			}
			if (remarksok) 
			{
				gnome_print_moveto (gpc, left, top);
				gnome_print_show (gpc, item[REMARKS]);
				left = left + 0.5 + wremarks * fwidth;
			}
			if (contest)
			{
			/* leave empty */
			}
			k++;
			if ((k % 30 == 0 && preferences.printorientation == 1)
				|| (k % 50 == 0 && preferences.printorientation == 0))
			{ /* footer after 30 or 50 QSO's */
				top = BOTTOMMARGIN;
				left = LEFTMARGIN;
				gnome_print_moveto (gpc, left, top);
				if (preferences.printorientation == 1)
					gnome_print_lineto (gpc, left + pheight - 2 * LEFTMARGIN, top);				
				else
					gnome_print_lineto (gpc, left + pwidth - 2 * LEFTMARGIN, top);				
				gnome_print_stroke (gpc);
				if (ifont) 
					gnome_print_setfont (gpc, ifont);
				left = LEFTMARGIN;
				top = top - 2 * fheight;
				temp = g_strdup_printf ("Printed by %s version %s", PACKAGE, VERSION);
				gnome_print_moveto (gpc, left + pwidth/2 - 100, top);
				gnome_print_show (gpc, temp);
				/* end page and start a new one */
				gnome_print_showpage (gpc);
			}
		} /* end of for loop*/
	/* footer for last page */
	if ((k % 30 != 0 && preferences.printorientation == 1)
		|| (k % 50 != 0 && preferences.printorientation == 0))
	{
		top = BOTTOMMARGIN;
		left = LEFTMARGIN;
		gnome_print_moveto (gpc, left, top);
		if (preferences.printorientation == 1)
			gnome_print_lineto (gpc, left + pheight - 2 * LEFTMARGIN, top);				
		else
			gnome_print_lineto (gpc, left + pwidth - 2 * LEFTMARGIN, top);				
		gnome_print_stroke (gpc);
		if (ifont) 
			gnome_print_setfont (gpc, ifont);
		left = LEFTMARGIN;
		top = top - 2 * fheight;
		temp = g_strdup_printf ("Printed by %s version %s", PACKAGE, VERSION);
		gnome_print_moveto (gpc, left + pwidth/2 - 100, top);
		gnome_print_show (gpc, temp);
		gnome_print_showpage (gpc);
		}
	}

	g_free (item);
	if (font) g_object_unref (G_OBJECT (font));
	gnome_print_job_close (job);
	gnome_print_job_print (job);
	g_object_unref (G_OBJECT (config));
	g_object_unref (G_OBJECT (gpc));
	g_object_unref (G_OBJECT (job));
	g_free (papersize);
	g_free (fontsize);
	g_free (psfile);
	g_free (temp);

	gtk_widget_set_sensitive (mainwindow, 1);
	gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET (button)));
}


/* cancel clicked, nothing printed */
void
on_printcancelbutton_clicked (GtkButton * button, gpointer user_data)
{
	gtk_widget_set_sensitive (mainwindow, 1);
	gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET (button)));
}

/* print dialog is deleted */
gboolean
on_printdialog_delete_event (GtkWidget * widget, GdkEvent * event,
					 gpointer user_data)
{
	gtk_widget_set_sensitive (mainwindow, 1);
	return FALSE;
}

/* set sensitivity of range widgets in print dialog */
void
on_printradiobutton_toggled (GtkToggleButton * togglebutton,
					 gpointer user_data)
{
	GtkWidget *printlowentry, *printrangelabel, *printhighentry;

	printlowentry = lookup_widget (printdialog, "printlowentry");
	printhighentry = lookup_widget (printdialog, "printhighentry");
	printrangelabel = lookup_widget (printdialog, "printrangelabel");
	switch (atoi (user_data))
		{
		case 1:
			gtk_widget_set_sensitive (printlowentry, 0);
			gtk_widget_set_sensitive (printhighentry, 0);
			gtk_widget_set_sensitive (printrangelabel, 0);
			break;
		case 2:
			gtk_widget_set_sensitive (printlowentry, 1);
			gtk_widget_set_sensitive (printhighentry, 1);
			gtk_widget_set_sensitive (printrangelabel, 1);
			break;
		}
}
