/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.trace.Trace;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.management.DynamicMBean;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;

public class Introspector {
    private static final String attributeDescription = "Attribute exposed for management";
    private static final String operationDescription = "Operation exposed for management";
    private static final String constructorDescription = "Public constructor of the MBean";
    private static final String mbeanInfoDescription = "Information on the management interface of the MBean";

    private Introspector() {
    }

    public static final boolean isDynamic(Class clazz) {
        return DynamicMBean.class.isAssignableFrom(clazz);
    }

    public static void testCreation(Class clazz) throws NotCompliantMBeanException {
        int n2 = clazz.getModifiers();
        if (Modifier.isAbstract(n2) || Modifier.isInterface(n2)) {
            throw new NotCompliantMBeanException("MBean class must be concrete");
        }
        Constructor[] constructorArray = clazz.getConstructors();
        if (constructorArray.length == 0) {
            throw new NotCompliantMBeanException("MBean class must have public constructor");
        }
    }

    public static MBeanInfo testCompliance(Class clazz) throws NotCompliantMBeanException {
        if (Introspector.isDynamic(clazz)) {
            return null;
        }
        return Introspector.testCompliance(clazz, null);
    }

    static MBeanInfo testCompliance(Class clazz, Class clazz2) throws NotCompliantMBeanException {
        if (clazz.isInterface()) {
            throw new NotCompliantMBeanException(clazz.getName() + " must be a class.");
        }
        if (clazz2 == null) {
            clazz2 = Introspector.getStandardMBeanInterface(clazz);
        } else {
            if (!clazz2.isAssignableFrom(clazz)) {
                String string = clazz.getName() + " does not implement the " + clazz2.getName() + " interface";
                throw new NotCompliantMBeanException(string);
            }
            if (!clazz2.isInterface()) {
                String string = clazz.getName() + ": " + clazz2.getName() + " is not an interface";
                throw new NotCompliantMBeanException(string);
            }
        }
        if (clazz2 == null) {
            String string = clazz.getName();
            String string2 = string + " does not implement the " + string + "MBean interface or the DynamicMBean interface";
            throw new NotCompliantMBeanException(string2);
        }
        int n2 = clazz2.getModifiers();
        if (!Modifier.isPublic(n2)) {
            throw new NotCompliantMBeanException(clazz2.getName() + " implemented by " + clazz.getName() + " must be public");
        }
        return Introspector.introspect(clazz, clazz2);
    }

    public static Class getMBeanInterface(Class clazz) {
        if (Introspector.isDynamic(clazz)) {
            return null;
        }
        return Introspector.getStandardMBeanInterface(clazz);
    }

    static Class getStandardMBeanInterface(Class clazz) {
        Class clazz2 = null;
        for (Class clazz3 = clazz; clazz3 != null && (clazz2 = Introspector.findMBeanInterface(clazz3, clazz3.getName())) == null; clazz3 = clazz3.getSuperclass()) {
        }
        return clazz2;
    }

    private static Class findMBeanInterface(Class clazz, String string) {
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Class[] classArray = clazz2.getInterfaces();
            int n2 = classArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Class clazz3 = Introspector.implementsMBean(classArray[i2], string);
                if (clazz3 == null) continue;
                return clazz3;
            }
        }
        return null;
    }

    private static MBeanInfo introspect(Class clazz, Class clazz2) throws NotCompliantMBeanException {
        ArrayList<MBeanAttributeInfo> arrayList = new ArrayList<MBeanAttributeInfo>();
        ArrayList<MBeanOperationInfo> arrayList2 = new ArrayList<MBeanOperationInfo>();
        Method[] methodArray = clazz2.getMethods();
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            Method method = methodArray[i2];
            String string = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            Class<?> clazz3 = method.getReturnType();
            int n2 = classArray.length;
            try {
                MBeanAttributeInfo mBeanAttributeInfo = string.startsWith("get") && !string.equals("get") && n2 == 0 && !clazz3.equals(Void.TYPE) ? new MBeanAttributeInfo(string.substring(3), attributeDescription, method, null) : (string.startsWith("set") && !string.equals("set") && n2 == 1 && clazz3.equals(Void.TYPE) ? new MBeanAttributeInfo(string.substring(3), attributeDescription, null, method) : (string.startsWith("is") && !string.equals("is") && n2 == 0 && clazz3.equals(Boolean.TYPE) ? new MBeanAttributeInfo(string.substring(2), attributeDescription, method, null) : null));
                if (mBeanAttributeInfo != null) {
                    if (!Introspector.testConsistency(arrayList, mBeanAttributeInfo)) continue;
                    arrayList.add(mBeanAttributeInfo);
                    continue;
                }
                MBeanOperationInfo mBeanOperationInfo = new MBeanOperationInfo(operationDescription, method);
                arrayList2.add(mBeanOperationInfo);
                continue;
            }
            catch (IntrospectionException introspectionException) {
                Introspector.error("introspect", introspectionException);
            }
        }
        return Introspector.constructResult(clazz, arrayList, arrayList2);
    }

    private static boolean testConsistency(List list, MBeanAttributeInfo mBeanAttributeInfo) throws NotCompliantMBeanException {
        for (MBeanAttributeInfo mBeanAttributeInfo2 : list) {
            if (!mBeanAttributeInfo2.getName().equals(mBeanAttributeInfo.getName())) continue;
            if (mBeanAttributeInfo.isReadable() && mBeanAttributeInfo2.isReadable() && mBeanAttributeInfo.isIs() != mBeanAttributeInfo2.isIs()) {
                String string = "Conflicting getters for attribute " + mBeanAttributeInfo2.getName();
                throw new NotCompliantMBeanException(string);
            }
            if (!mBeanAttributeInfo2.getType().equals(mBeanAttributeInfo.getType())) {
                if (mBeanAttributeInfo2.isWritable() && mBeanAttributeInfo.isWritable()) {
                    String string = "Type mismatch between parameters of set" + mBeanAttributeInfo2.getName() + " methods";
                    throw new NotCompliantMBeanException(string);
                }
                String string = "Type mismatch between parameters of get or is" + mBeanAttributeInfo2.getName() + ", set" + mBeanAttributeInfo2.getName() + " methods";
                throw new NotCompliantMBeanException(string);
            }
            if (mBeanAttributeInfo.isReadable() && mBeanAttributeInfo2.isReadable()) {
                return false;
            }
            if (!mBeanAttributeInfo.isWritable() || !mBeanAttributeInfo2.isWritable()) continue;
            return false;
        }
        return true;
    }

    static MBeanConstructorInfo[] getConstructors(Class clazz) {
        Constructor[] constructorArray = clazz.getConstructors();
        ArrayList<MBeanConstructorInfo> arrayList = new ArrayList<MBeanConstructorInfo>();
        for (int i2 = 0; i2 < constructorArray.length; ++i2) {
            Constructor constructor = constructorArray[i2];
            MBeanConstructorInfo mBeanConstructorInfo = null;
            try {
                mBeanConstructorInfo = new MBeanConstructorInfo(constructorDescription, constructor);
            }
            catch (Exception exception) {
                mBeanConstructorInfo = null;
            }
            if (mBeanConstructorInfo == null) continue;
            arrayList.add(mBeanConstructorInfo);
        }
        MBeanConstructorInfo[] mBeanConstructorInfoArray = new MBeanConstructorInfo[arrayList.size()];
        arrayList.toArray(mBeanConstructorInfoArray);
        return mBeanConstructorInfoArray;
    }

    private static MBeanInfo constructResult(Class clazz, List list, List list2) {
        Object object;
        MBeanOperationInfo[] mBeanOperationInfoArray;
        int n2 = list.size();
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[n2];
        list.toArray(mBeanAttributeInfoArray);
        ArrayList<MBeanOperationInfo[]> arrayList = new ArrayList<MBeanOperationInfo[]>();
        for (int i2 = 0; i2 < n2; ++i2) {
            mBeanOperationInfoArray = mBeanAttributeInfoArray[i2];
            if (mBeanOperationInfoArray == null) continue;
            object = mBeanOperationInfoArray;
            for (int i3 = i2 + 1; i3 < n2; ++i3) {
                MBeanAttributeInfo mBeanAttributeInfo = mBeanAttributeInfoArray[i3];
                if (mBeanAttributeInfo == null || mBeanAttributeInfo.getName().compareTo(mBeanOperationInfoArray.getName()) != 0) continue;
                mBeanAttributeInfoArray[i3] = null;
                object = new MBeanAttributeInfo(mBeanOperationInfoArray.getName(), mBeanOperationInfoArray.getType(), attributeDescription, true, true, mBeanOperationInfoArray.isIs());
            }
            arrayList.add((MBeanOperationInfo[])object);
        }
        MBeanAttributeInfo[] mBeanAttributeInfoArray2 = new MBeanAttributeInfo[arrayList.size()];
        arrayList.toArray(mBeanAttributeInfoArray2);
        mBeanOperationInfoArray = new MBeanOperationInfo[list2.size()];
        list2.toArray(mBeanOperationInfoArray);
        object = Introspector.getConstructors(clazz);
        MBeanInfo mBeanInfo = new MBeanInfo(clazz.getName(), mbeanInfoDescription, mBeanAttributeInfoArray2, (MBeanConstructorInfo[])object, mBeanOperationInfoArray, null);
        return mBeanInfo;
    }

    static Class implementsMBean(Class clazz, String string) {
        if (clazz.getName().compareTo(string + "MBean") == 0) {
            return clazz;
        }
        Class clazz2 = clazz;
        Class[] classArray = clazz.getInterfaces();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            try {
                if (classArray[i2].getName().compareTo(string + "MBean") != 0) continue;
                return classArray[i2];
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    private static void error(String string, Throwable throwable) {
        Trace.send(0, 1, "Introspector", string, throwable);
    }
}

