/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.util.Collection;

public class CertStore {
    private static final String CERT_STORE = "CertStore";
    private CertStoreSpi storeSpi;
    private Provider provider;
    private String type;
    private CertStoreParameters params;

    protected CertStore(CertStoreSpi storeSpi, Provider provider, String type, CertStoreParameters params) {
        this.storeSpi = storeSpi;
        this.provider = provider;
        this.type = type;
        this.params = params;
    }

    public static final synchronized String getDefaultType() {
        String type = null;
        type = (String)AccessController.doPrivileged(new PrivilegedAction(null){
            private /* synthetic */ CertStore this$0;
            {
                this.this$0 = this$0;
            }

            public Object run() {
                return Security.getProperty("certstore.type");
            }
        });
        if (type == null) {
            type = "LDAP";
        }
        return type;
    }

    public static CertStore getInstance(String type, CertStoreParameters params) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        for (int i = 0; i < p.length; ++i) {
            try {
                return CertStore.getInstance(type, params, p[i]);
            }
            catch (NoSuchAlgorithmException ignored) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException(type);
    }

    public static CertStore getInstance(String type, CertStoreParameters params, String provider) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return CertStore.getInstance(type, params, p);
    }

    public static CertStore getInstance(String type, CertStoreParameters params, Provider provider) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("null provider");
        }
        try {
            return new CertStore((CertStoreSpi)Engine.getInstance(CERT_STORE, type, provider, new Object[]{params}), provider, type, params);
        }
        catch (ClassCastException cce) {
            throw new NoSuchAlgorithmException(type);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof InvalidAlgorithmParameterException) {
                throw (InvalidAlgorithmParameterException)cause;
            }
            throw new NoSuchAlgorithmException(type);
        }
    }

    public final String getType() {
        return this.type;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final CertStoreParameters getCertStoreParameters() {
        if (this.params != null) {
            return (CertStoreParameters)this.params.clone();
        }
        return null;
    }

    public final Collection getCertificates(CertSelector selector) throws CertStoreException {
        return this.storeSpi.engineGetCertificates(selector);
    }

    public final Collection getCRLs(CRLSelector selector) throws CertStoreException {
        return this.storeSpi.engineGetCRLs(selector);
    }
}

