.\"
.\" $XdotOrg: xc/lib/XRes/XRes.man,v 1.1.4.1.4.3 2004/04/02 21:47:11 eich Exp $
.\" $XFree86: xc/lib/XRes/XRes.man,v 1.2 2003/10/13 21:22:54 herrb Exp $
.\"
.\" Copyright (C) 1994-2003 The XFree86 Project, Inc.  All Rights Reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\" 
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
.\" IN NO EVENT SHALL THE XFREE86 PROJECT BE LIABLE FOR ANY CLAIM, DAMAGES
.\" OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
.\" OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
.\" THE USE OR OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of the XFree86 Project
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" from the XFree86 Project.
.\" 
.TH XRes 3 __vendorversion__
.SH NAME
XRes \- X-Resource extension client library
.SH SYNOPSIS
.B #include <X11/extension/XRes.h>
.PP
.nf
.ta .5i 2i
typedef struct {
	XID	resource_base;
	XID	resource_mask;
} XResClient;

typedef struct {
	Atom	resource_type;
	unsigned int	count;
} XResType;
.fi
.HP
Bool XResQueryExtension(Display *\fIdpy\fP, 
int *\fIevent_basep\fP, int *\fIerror_basep\fP\^);
.HP
Status XResQueryVersion(Display *\fIdpy\fP, int *\fImajor_versionp\fP,
int *\fIminor_versionp\fP\^);
.HP
Status XResQueryClients(Display *\fIdpy\fP, int *\fInum_clients\fP, 
XResClient **\fIclients\fP\^);
.HP
Status XResQueryClientResources(Display *\fIdpy\fP, XID \fIxid\fP, 
int *\fInum_types\fP, XResType **\fItypes\fP\^);
.HP
Status XResQueryClientPixmapBytes(Display *\fIdpy\fP, XID \fIxid\fP, 
unsigned long *\fIbytes\fP\^);
.PP
.SH DESCRIPTION
.B X-Resource
is an extension that allows a client to query the X
server about its usage of various resources. It should not be mixed
with the X resource database access functions.
.PP
.B XResQueryExtension
returns
.B True
if the 
.I XRes
extension is available on the given display.
A client must call 
.B XResQueryExtension
before calling any other XRes function in order
to negotiate a compatible protocol version; otherwise the client will
get undefined behavior (XRes may or may not work).
.PP
.B XResQueryVersion
returns
.B True
if the request succeeded; the values of the major and minor protocol
versions supported by the server are returned in 
.I major_versionp 
and 
.I minor_versionp .
.PP
.PP
.B XResQueryClients 
fills a list of clients of the given display. For each client it
returns in the 
.I XResClient
structure a mask and a base value of the resources used by these
clients. 
Returns 
.B True
on success or 
.B False
on failure. 
.PP
.B XResQueryClientResources
fills a list of 
XResType
structures, indicating for each resource type allocated by the client its
name (as an Atom) and the number of resources of this type allocated. 
Returns 
.B True
on success or 
.B False
on failure. 
.PP
.B XresQueryClientPixmapBytes
gives, for resources of type 
.I PIXMAP
the total number of bytes allocated in the X server by the given
client. 
Returns 
.B True
on success or 
.B False
on failure. 
.SH "ERRORS"
.B XResQueryClientResources
and
.B XResQueryClientPixmapBytes
will return 
.I BadValue
if passed an illegal client identifier. 
.SH "SEE ALSO"
X(__miscmansuffix__)
.SH AUTHOR
Mark Vojkovich, originally for The XFree86 Project Inc. 
.SH STABILITY
This API is considered as experimental. The XRes library major
revision may be incremented whenever incompatible changes are done to
the API without notice. Use with care. 
