.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.TH glutGetModifiers 3GLUT "3.7" "GLUT" "GLUT"
.SH NAME
glutGetModifiers - returns the modifier key state when certain
callbacks were generated. 
.SH SYNTAX
.nf
.LP
int glutGetModifiers(void);
.fi
.SH DESCRIPTION
glutGetModifiers returns the modifier key state at the time the
input event for a keyboard, special, or mouse callback is generated.
This routine may only be called while a keyboard, special, or mouse
callback is being handled. The window system is permitted to intercept
window system defined modifier key strokes or mouse buttons, in
which case, no GLUT callback will be generated. This interception
will be independent of use of glutGetModifiers. 

The bitmask components of the returned integer value are:
.TP 8
.B GLUT_ACTIVE_SHIFT 
Set if the Shift modifier or Caps Lock is active. 
.TP 8
.B GLUT_ACTIVE_CTRL 
Set if the Ctrl modifier is active. 
.TP 8
.B GLUT_ACTIVE_ALT 
Set if the Alt modifier is active. 
.SH SEE ALSO
glutSpecialFunc, glutKeyboardFunc, glutMouseFunc
.SH AUTHOR
Mark J. Kilgard (mjk@nvidia.com)
