/***************************************************************************
                            KListView.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KLISTVIEW_H
#define KLISTVIEW_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QListView.h>

/**

 This Widget extends the functionality of QListView to honor the system
 wide settings for Single Click/Double Click mode, AutoSelection and
 ChangeCursorOverLink (TM).

 There is a new signal -executed. It gets connected to either
 @ref -[QListView clicked] or  @ref -[QListView doubleClicked] depending on the KDE
 wide Single Click/Double Click settings. It is strongly recommended that
 you use this signal instead of the above mentioned. This way you dont
 need to care about the current settings.
 If you want to get informed when the user selects something connect to the
 -[QListView selectionChanged] signal.

 Drag-and-Drop is supported with the signal @ref  #--dropped, just @ref  #-setAcceptDrops(true)
 and connect it to a suitable slot.
 To see where you are dropping, @ref setDropVisualizer(true).
 And also you'll need @ref acceptDrag(QDropEvent*)

 KListView is drag-enabled, too: to benefit from that you've got derive from it.
 Reimplement @ref -dragObject and (possibly) @ref -startDrag,
 and @ref setDragEnabled(true).

 @version $Id: KListView.h,v 1.3 2002/03/15 02:12:21 rdale Exp $
 
 @short 
 This Widget extends the functionality of QListView to honor the system
 wide settings for Single Click/Double Click mode, AutoSelection and
 ChangeCursorOverLink (TM).
*/
@class KConfig; 
@class QListView; 

@interface KListView : QListView 

/** 
 Constructor.

 The parameters @p parent and @p name are handled by
 @ref QListView, as usual.
   
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/** 
 Destructor.
   
*/
- (void) dealloc;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- setAcceptDrops: (BOOL)arg1;

/** 
 This function determines whether the given coordinates are within the
 execute area. The execute area is the part of a @ref QListViewItem where mouse
 clicks or double clicks respectively generate a @ref  #--executed signal.
 Depending on @ref -[QListView allColumnsShowFocus] this is either the
 whole item or only the first column.

*/
- (BOOL) isExecuteArea: (QPoint*)point;

/** 
 Same thing, but from an x coordinate only. This only checks if x is in
 the first column (if all columns don't show focus), without testing if
 the y coordinate is over an item or not.
   
*/
- (BOOL) isExecuteAreaAtXCoord: (int)x;

/** 
 Arbitrarily move @p item to @p parent, positioned immediately after item @p after.
   
*/
- moveItem: (QListViewItem *)item parent: (QListViewItem *)parent after: (QListViewItem *)after;

/** 

*/
- (QListViewItem*) lastItem;

/** 

*/
- (QListViewItem*) lastChild;

/** 

*/
- (BOOL) itemsMovable;

/** 

*/
- (BOOL) itemsRenameable;

/** 

*/
- (BOOL) dragEnabled;

/** 

*/
- (BOOL) autoOpen;

/** 

*/
- (BOOL) isRenameable: (int)column;

/** 

*/
- (BOOL) dropVisualizer;

/** 

*/
- (int) tooltipColumn;

/** 
 For future expansions.

 Do not use.

   
*/
- (BOOL) createChildren;

/** 

*/
- (BOOL) dropHighlighter;

/** 
 The dropVisualizerWidth defaults to 4.

*/
- (int) dropVisualizerWidth;

/** 

*/
- (int) selectionModeExt;

/** 
 Returns the index of @p item within the item tree or -1 if
 @p item doesn't exist in this list view. This function takes
 all items into account not only the visible ones.
   
*/
- (int) itemIndex: (QListViewItem *)item;

/** 
 Returns the item of @p index within the item tree or 0 if
 @p index doesn't exist in this list view. This function takes
 all items into account not only the visible ones.
   
*/
- (QListViewItem*) itemAtIndex: (int)index;

/** 

   
*/
- setFullWidth;

/** 
 Let the last column fit exactly all the available width.
   
*/
- setFullWidth: (BOOL)fullWidth;

/** 
 Returns whether the last column is set to fit the available width.
   
*/
- (BOOL) fullWidth;

/** 
 sets the alternate background background color.
 This only has an effect if the items are KListViewItems

*/
- setAlternateBackground: (QColor *)c;

/** 

*/
- (QColor*) alternateBackground;

/** 
 Saves the list view's layout (column widtsh, column order, sort column)
 to a KConfig group

*/
- saveLayout: (KConfig*)config group: (NSString *)group;

/** 
 Reads the list view's layout from a KConfig group as stored with
 @ref saveLayout

*/
- restoreLayout: (KConfig*)config group: (NSString *)group;

/** 
 Reimplemented to remember the current sort column and order
   
*/
- setSorting: (int)column ascending: (BOOL)ascending;
- setSorting: (int)column ;

/** 
 Rename column @p c of @p item.
   
*/
- rename: (QListViewItem *)item c: (int)c;

/** 
 By default, if you called setItemsRenameable(true),
 only the first column is renameable.
 Use this function to enable the feature on other columns.

 If you want more intelligent (dynamic) selection,
 you'll have to derive from KListView,
 and override @ref -rename and call only call it
 if you want the item to be renamed.

*/
- setRenameable: (int)column yesno: (BOOL)yesno;
- setRenameable: (int)column ;

/** 
 Set whether items in the list view can be moved.
 It is enabled by default.

*/
- setItemsMovable: (BOOL)b;

/** 
 Enables inplace-renaming of items.
 It is disabled by default.

*/
- setItemsRenameable: (BOOL)b;

/** 
 Enable/Disable the dragging of items.
 It is disabled by default.
   
*/
- setDragEnabled: (BOOL)b;

/** 
 Enable/Disable AutoOpen (not implemented currently).
   
*/
- setAutoOpen: (BOOL)b;

/** 
 Enable/Disable the drawing of a drop-visualizer
 (a bar that shows where a dropped item would be inserted).
 It is enabled by default, if dragging is enabled
   
*/
- setDropVisualizer: (BOOL)b;

/** 
 Set the width of the (default) drop-visualizer.
 If you don't call this method, the width is set to 4.
   
*/
- setDropVisualizerWidth: (int)w;

/** 
 Set which column should be used for automatic tooltips.

*/
- setTooltipColumn: (int)column;

/** 
 Enable/Disable the drawing of a drop-highlighter
 (a rectangle around the item under the mouse cursor).
 It is disabled by default.
   
*/
- setDropHighlighter: (BOOL)b;

/** 
 For future expansions.

 Do not use.

   
*/
- setCreateChildren: (BOOL)b;

/** 
 Set the selection mode.

 A different name was chosen to avoid API-clashes with @ref -[QListView setSelectionMode].
   
*/
- setSelectionModeExt: (int)mode;

/** 
 Determine whether a drop on position @p p would count as
 being above or below the QRect @p rect.

*/
- (BOOL) belowRect: (QRect*)rect p: (QPoint*)p;

/** 
 An overloaded version of below(const QRect&, const QPoint&).

 It differs from the above only in what arguments it takes.

*/
- (BOOL) belowListViewItem: (QListViewItem *)i p: (QPoint*)p;

/** 
 Reimplemented to reload the alternate background in palette changes.

   
*/
- (BOOL) event: (QEvent *)arg1;

/** 
 Emit signal @ref executed.

   
*/
- emitExecute: (QListViewItem *)item pos: (QPoint*)pos c: (int)c;

/** 

*/
- (NSString *) tooltip: (QListViewItem *)item column: (int)column;

/** 

*/
- (BOOL) showTooltip: (QListViewItem *)item pos: (QPoint*)pos column: (int)column;

/** 

*/
- (QDragObject*) dragObject;

/** 

*/
- (BOOL) acceptDrag: (QDropEvent*)event;

/** 
 Paint the drag line. If painter is null, don't try to :)

 If after == 0 then the marker should be drawn at the top.

*/
- (QRect*) drawDropVisualizer: (QPainter *)p parent: (QListViewItem *)parent after: (QListViewItem *)after;

/** 
 Paint the drag rectangle. If painter is null, don't try to :)

*/
- (QRect*) drawItemHighlighter: (QPainter *)painter item: (QListViewItem *)item;

/** 
 This method calls @ref -dragObject and starts the drag.

 Reimplement it to do fancy stuff like setting a pixmap or
 using a non-default DragMode
   
*/
- startDrag;

/** 
 Only called by konq_listviewwidget to select the current item
 after listing. For more information look in -konquerorKeyPressEvent.
   
*/
- selectCurrentItemAndEnableSelectedBySimpleMoveMode;

/** 
 Where is the nearest QListViewItem that I'm going to drop?
   
*/
- findDrop: (QPoint*)pos parent: (QListViewItem*)parent after: (QListViewItem*)after;

/** 
 Convert the depth of an item into its indentation in pixels
   
*/
- (int) depthToPixels: (int)depth;

/** 
 Update internal settings whenever the global ones change.

   
*/
- slotSettingsChanged: (int)arg1;
- slotMouseButtonClicked: (int)btn item: (QListViewItem *)item pos: (QPoint*)pos c: (int)c;
- doneEditing: (QListViewItem *)item row: (int)row;

/** 
 Repaint the rect where I was drawing the drop line.
   
*/
- cleanDropVisualizer;

/** 
 Repaint the rect where I was drawing the drop rectangle.
   
*/
- cleanItemHighlighter;

/** 
 Emit the @ref contextMenu signal. This slot is for mouse actions.
   
*/
- emitContextMenu: (QListViewItem *)arg1 point: (QPoint*)arg2 int: (int)arg3;

/** 
 Emit the @ref contextMenu signal. This slot is for key presses.
   
*/
- emitContextMenu: (KListView*)arg1 listviewitem: (QListViewItem *)arg2;

/** 
 Accessory slot for AutoSelect

   
*/
- slotOnItem: (QListViewItem *)item;

/** 
 Accessory slot for AutoSelect/ChangeCursorOverItem

   
*/
- slotOnViewport;

/** 
 Process AutoSelection.

   
*/
- slotAutoSelect;

/** 
 Reacts to header changes in full width mode

   
*/
- slotHeaderChanged;
+ (int) Single;
+ (int) Multi;
+ (int) Extended;
+ (int) NoSelection;
+ (int) Konqueror;
@end

/** Override these methods in subclasses of KListView to customise event handling behaviour */
@protocol KListViewEventHandling

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- focusOutEvent:(QFocusEvent*) fe;
- childEvent:(QChildEvent*) arg1;
- viewportDragMoveEvent:(QDragMoveEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- contentsWheelEvent:(QWheelEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- leaveEvent:(QEvent*) e;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contentsContextMenuEvent:(QContextMenuEvent*) e;
- viewportContextMenuEvent:(QContextMenuEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- viewportMousePressEvent:(QMouseEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- viewportMouseReleaseEvent:(QMouseEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;

/** 
 A special keyPressEvent (for Konqueror-style selection).
   
*/
- konquerorKeyPressEvent:(QKeyEvent*) arg1;
- viewportMouseDoubleClickEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- viewportDragLeaveEvent:(QDragLeaveEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- contentsDropEvent:(QDropEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- focusInEvent:(QFocusEvent*) fe;
- imEndEvent:(QIMEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- contentsDragLeaveEvent:(QDragLeaveEvent*) event;
- viewportDropEvent:(QDropEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- contentsMouseDoubleClickEvent:(QMouseEvent*) e;
- viewportDragEnterEvent:(QDragEnterEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- viewportMouseMoveEvent:(QMouseEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- contentsDragMoveEvent:(QDragMoveEvent*) event;
- moveEvent:(QMoveEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- contentsMouseReleaseEvent:(QMouseEvent*) arg1;
- viewportWheelEvent:(QWheelEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- contentsDragEnterEvent:(QDragEnterEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- contentsMouseMoveEvent:(QMouseEvent*) e;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- contentsMousePressEvent:(QMouseEvent*) e;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
- viewportPaintEvent:(QPaintEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;

/** 
 Reimplemented for -setFullWidth
   
*/
- viewportResizeEvent:(QResizeEvent*) e;
- resizeEvent:(QResizeEvent*) e;
@end


#endif
