/***************************************************************************
                            kde_KShortcut.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSHORTCUT
#define KDE_KSHORTCUT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

#define KSHORTCUT_MAX_SEQUENCES	2

/** *
 Creates a new null shortcut.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KShortcut * kde_new_KShortcut();

/** *
 Creates a new shortcut with the given Qt key code
 as the only key sequence.

*/
kde_KShortcut * kde_new_KShortcut1(int keyQt);

/** *
 Creates a new shortcut that contains only the given qt key
 sequence.

*/
kde_KShortcut * kde_new_KShortcut2(qt_QKeySequence* keySeq);

/** *
 Creates a new shortcut that contains only the given key
 in its only sequence.

*/
kde_KShortcut * kde_new_KShortcut3(kde_KKey* key);

/** *
 Creates a new shortcut that contains only the given key
 sequence.

*/
kde_KShortcut * kde_new_KShortcut4(kde_KKeySequence* keySeq);

/** *
 Copies the given shortcut.

*/
kde_KShortcut * kde_new_KShortcut5(kde_KShortcut* shortcut);

/** *
 Creates a new key sequence that contains the given key sequence.
 The description consists of semicolon-separated keys as
 used in @ref KKeySequence::KKeySequence(const QString&).

*/
kde_KShortcut * kde_new_KShortcut6(char* shortcut);

/** *
 Creates a new key sequence that contains the given key sequence.
 The description consists of semicolon-separated keys as
 used in @ref KKeySequence::KKeySequence(const QString&).

*/
kde_KShortcut * kde_new_KShortcut7(qt_QString * shortcut);
void kde_del_KShortcut( kde_KShortcut* p );

/** *
 Clears the shortcut. The shortcut is null after calling this 
 function.

*/
void kde_KShortcut_clear(kde_KShortcut* instPointer);

/** *
 Initializes the shortcut with the given Qt key code
 as the only key sequence.

*/
int kde_KShortcut_init(kde_KShortcut* instPointer,int keyQt);

/** *
 Initializes the shortcut with the given qt key sequence.

*/
int kde_KShortcut_init1(kde_KShortcut* instPointer,qt_QKeySequence* keySeq);

/** *
 Initializes the shortcut with the given key as its only sequence.

*/
int kde_KShortcut_init2(kde_KShortcut* instPointer,kde_KKey* key);

/** *
 Initializes the shortcut with the given qt key sequence.

*/
int kde_KShortcut_init3(kde_KShortcut* instPointer,kde_KKeySequence* keySeq);

/** *
 Copies the given shortcut.

*/
int kde_KShortcut_init4(kde_KShortcut* instPointer,kde_KShortcut* shortcut);

/** *
 Initializes the key sequence with the given key sequence.
 The description consists of semicolon-separated keys as
 used in @ref KKeySequence::KKeySequence(const QString&).

*/
int kde_KShortcut_init5(kde_KShortcut* instPointer,qt_QString * shortcut);

/** *
 Returns the number of sequences that are in this
 shortcut.

*/
unsigned int kde_KShortcut_count(kde_KShortcut* instPointer);

/** *
 Returns the @p i'th key sequence of this shortcut.

*/
kde_KKeySequence* kde_KShortcut_seq(kde_KShortcut* instPointer,unsigned int i);

/** *
 Returns the key code of the first key sequence, or 
 null if there is no first key sequence.

*/
int kde_KShortcut_keyCodeQt(kde_KShortcut* instPointer);

/** *
 Returns true if the shortcut is null (after @ref clear() or empty
 constructor).

*/
int kde_KShortcut_isNull(kde_KShortcut* instPointer);

/** *
 Compares this object with the given shortcut. Returns a negative 
 number if the given shortcut is larger, 0 if they are equal and
 a positive number this shortcut is larger. Shortcuts are
 compared by comparing the individual key sequences, starting from the 
 beginning until an unequal key sequences has been found. If a shortcut
 contains more key sequences, it is considered larger.

*/
int kde_KShortcut_compare(kde_KShortcut* instPointer,kde_KShortcut* shortcut);

/** *
 Checks whether this shortcut contains a sequence that starts
 with the given key.

*/
int kde_KShortcut_contains(kde_KShortcut* instPointer,kde_KKey* key);

/** *
 Checks whether this shortcut contains a sequence that starts
 with the given key.

*/
int kde_KShortcut_contains1(kde_KShortcut* instPointer,kde_KKeyNative* key);

/** *
 Checks whether this shortcut contains the given sequence.

*/
int kde_KShortcut_contains2(kde_KShortcut* instPointer,kde_KKeySequence* keySeq);

/** *
 Sets the @p i'th key sequence of the shortcut. You can not introduce 
 gaps in the list of sequences, so you must use an @i <= @ref count(). 
 Also note that the maximum number of key sequences is @ref MAX_SEQUENCES.

*/
int kde_KShortcut_setSeq(kde_KShortcut* instPointer,unsigned int i, kde_KKeySequence* keySeq);

/** *
 Appends the given key sequence.

*/
int kde_KShortcut_append(kde_KShortcut* instPointer,kde_KKeySequence* keySeq);

/** *
 Returns a description of the shortcut as semicolon-separated
 ket sequences, as returned by @ref KKeySequence::toString().

*/
qt_QString * kde_KShortcut_toString(kde_KShortcut* instPointer);

/** *

	 
*/
qt_QString * kde_KShortcut_toStringInternal(kde_KShortcut* instPointer,kde_KShortcut* pcutDefault);

/** *
 Returns a null shortcut.

*/
kde_KShortcut* kde_KShortcut_null( );

#ifdef __cplusplus
}
#endif
#endif
