/***************************************************************************
                            kde_KInstance.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KINSTANCE
#define KDE_KINSTANCE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Access to KDE global objects for use in shared libraries.  In
 practical terms, this class is used in KDE components.  This allows
 components to store things that normally would be accessed by
 @ref KGlobal.

 @author Torben Weis

 @version $Id: kde_KInstance.h,v 1.6 2002/12/30 14:37:06 geiseri Exp $
 
 @short *
 Access to KDE global objects for use in shared libraries.
*/

/** *
  Constructor.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KInstance * kde_new_KInstance(qt_QCString* instanceName);

/** *
  Constructor.
  When building a KInstance that is not your KApplication,
  make sure that the KAboutData and the KInstance have the same life time.
  You have to destroy both, since the instance doesn't own the about data.
  Don't build a KAboutData on the stack in this case !
  Building a KAboutData on the stack is only ok for usage with
  KCmdLineArgs and KApplication (not destroyed until the app exits).

*/
kde_KInstance * kde_new_KInstance1(kde_KAboutData* aboutData);
kde_KInstance * kde_new_KInstance2(kde_KInstance* src);

/** *
 Destructor.
     
*/
void kde_del_KInstance( kde_KInstance* p );

/** *
 Returns the application standard dirs object.

*/
kde_KStandardDirs* kde_KInstance_dirs(kde_KInstance* instPointer);

/** *
 Returns the general config object ("appnamerc").

*/
kde_KConfig* kde_KInstance_config(kde_KInstance* instPointer);

/** *
  Returns an iconloader object.

*/
kde_KIconLoader* kde_KInstance_iconLoader(kde_KInstance* instPointer);

/** *
 Re-allocate the global iconloader.
     
*/
void kde_KInstance_newIconLoader(kde_KInstance* instPointer);

/** *
  Returns the about data of this instance
  Warning, can be 0L

*/
kde_KAboutData* kde_KInstance_aboutData(kde_KInstance* instPointer);

/** *
 Returns the name of the instance

*/
qt_QCString* kde_KInstance_instanceName(kde_KInstance* instPointer);

/** *
 Returns the @ref KMimeSourceFactory of the instance.
 Mainly added for API completeness and future extensibility.

*/
kde_KMimeSourceFactory* kde_KInstance_mimeSourceFactory(kde_KInstance* instPointer);

/** *
  Copy Constructor is not allowed
     
*/
kde_KInstance * kde_new_KInstance3(kde_KInstance* arg1);

/** *
 Set name of default config file.

*/
void kde_KInstance_setConfigName(kde_KInstance* instPointer,qt_QString * name);
void kde_KInstance_virtual_hook(kde_KInstance* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
