/***************************************************************************
                            kde_HTMLFrameElement.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_HTMLFRAMEELEMENT
#define KDE_HTMLFRAMEELEMENT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Create a frame. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.html#edef-FRAME">
 FRAME element definition </a> in HTML 4.0.

 
 @short *
 Create a frame.
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_HTMLFrameElement * kde_new_HTMLFrameElement();
kde_HTMLFrameElement * kde_new_HTMLFrameElement1(kde_HTMLFrameElement* other);
kde_HTMLFrameElement * kde_new_HTMLFrameElement2(kde_DOMNode* other);
void kde_del_HTMLFrameElement( kde_HTMLFrameElement* p );

/** *
 Request frame borders. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-frameborder">
 frameborder attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLFrameElement_frameBorder(kde_HTMLFrameElement* instPointer);

/** *
 see @ref frameBorder
     
*/
void kde_HTMLFrameElement_setFrameBorder(kde_HTMLFrameElement* instPointer,kde_DOMString* arg1);

/** *
 URI designating a long description of this image or frame. See
 the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-longdesc-FRAME">
 longdesc attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLFrameElement_longDesc(kde_HTMLFrameElement* instPointer);

/** *
 see @ref longDesc
     
*/
void kde_HTMLFrameElement_setLongDesc(kde_HTMLFrameElement* instPointer,kde_DOMString* arg1);

/** *
 Frame margin height, in pixels. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-marginheight">
 marginheight attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLFrameElement_marginHeight(kde_HTMLFrameElement* instPointer);

/** *
 see @ref marginHeight
     
*/
void kde_HTMLFrameElement_setMarginHeight(kde_HTMLFrameElement* instPointer,kde_DOMString* arg1);

/** *
 Frame margin width, in pixels. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-marginwidth">
 marginwidth attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLFrameElement_marginWidth(kde_HTMLFrameElement* instPointer);

/** *
 see @ref marginWidth
     
*/
void kde_HTMLFrameElement_setMarginWidth(kde_HTMLFrameElement* instPointer,kde_DOMString* arg1);

/** *
 The frame name (object of the <code> target </code> attribute).
 See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-name-FRAME">
 name attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLFrameElement_name(kde_HTMLFrameElement* instPointer);

/** *
 see @ref name
     
*/
void kde_HTMLFrameElement_setName(kde_HTMLFrameElement* instPointer,kde_DOMString* arg1);

/** *
 When true, forbid user from resizing frame. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-noresize">
 noresize attribute definition </a> in HTML 4.0.

     
*/
int kde_HTMLFrameElement_noResize(kde_HTMLFrameElement* instPointer);

/** *
 see @ref noResize
     
*/
void kde_HTMLFrameElement_setNoResize(kde_HTMLFrameElement* instPointer,int arg1);

/** *
 Specify whether or not the frame should have scrollbars. See
 the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-scrolling">
 scrolling attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLFrameElement_scrolling(kde_HTMLFrameElement* instPointer);

/** *
 see @ref scrolling
     
*/
void kde_HTMLFrameElement_setScrolling(kde_HTMLFrameElement* instPointer,kde_DOMString* arg1);

/** *
 A URI designating the initial frame contents. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-src-FRAME">
 src attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLFrameElement_src(kde_HTMLFrameElement* instPointer);

/** *
 see @ref src
     
*/
void kde_HTMLFrameElement_setSrc(kde_HTMLFrameElement* instPointer,kde_DOMString* arg1);

/** *
 Introduced in DOM Level 2

 Returns the document this frame contains, if there is any and
 it is available, a Null document otherwise. The attribute is
 read-only.

*/
kde_Document* kde_HTMLFrameElement_contentDocument(kde_HTMLFrameElement* instPointer);

#ifdef __cplusplus
}
#endif
#endif
