/*****************************************************************

Copyright (c) 1996-2003 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __panel_h__
#define __panel_h__

#include <dcopobject.h>

#include "global.h"
#include "container_panel.h"

class ContainerArea;
class FittsLawFrame;
class PanelOpMenu;
class QVBoxLayout;

class Panel : public PanelContainer, virtual public DCOPObject
{
    Q_OBJECT
    K_DCOP

public:
    static Panel* the();

    Panel();
    ~Panel();

    void initialize();
    //Just like QFrame::setFrameStyle
    void setFrameStyle( int style );

k_dcop:
    int panelSize();
    int panelOrientation() { return static_cast<int>(orientation()); }
    int panelPosition() { return static_cast<int>(position()); }

    void setPanelSize(int size);
    void setPanelPosition(int position) { setPosition(static_cast<Position>(position)); }

    // It makes sense to have these in Panel and not in ContainerArea, think of child panels.
    void addKMenuButton();
    void addDesktopButton();
    void addWindowListButton();
    void addURLButton(const QString &url);
    void addBrowserButton(const QString &startDir);
    void addServiceButton(const QString& desktopEntry);
    void addServiceMenuButton(const QString &name, const QString& relPath);
    void addNonKDEAppButton(const QString &filePath, const QString &icon, const QString &cmdLine, bool inTerm);
    void addApplet( const QString &desktopFile  );

    void restart();
    void configure();

public:
    QSize sizeHint( Position p, const QSize &maxSize );

    ContainerArea *containerArea() { return _containerArea; }
    PanelOpMenu *opMenu();

    void readConfig();
    void writeConfig();

    virtual QString panelId() const { return "MainPanel"; }

protected:
    virtual void showPanelMenu( const QPoint &globalPos );
    virtual bool vetoAutoHide() const;
    void closeEvent( QCloseEvent * );

protected slots:
    void slotResizeableHandleChange( bool resizeablehandle );
    void slotSizeChange( Size s, int customSize );
    void slotPositionChange( Position p );
    void slotAlignmentChange( Alignment a );
    void slotResizeRequest( int dx, int dy );

private:
    FittsLawFrame*    _frame;
    ContainerArea*    _containerArea;
    PanelOpMenu*      _opMnu;
    //we need that for setting margins
    QVBoxLayout*      _layout;
};

#endif // __panel_h__
