// abiword stuff
#include "fd_Field.h"
#include "fl_AutoNum.h"
#include "fp_PageSize.h"

#include "px_ChangeRecord.h"
#include "px_CR_Object.h"
#include "px_CR_Span.h"
#include "px_CR_Strux.h"
#include "pd_Document.h"
#include "pp_AttrProp.h"

#include "ut_misc.h"
#include "ut_string.h"
#include "ut_string_class.h"
#include "ut_bytebuf.h"
#include "ut_hash.h"
#include "ut_vector.h"
#include "ut_stack.h"
#include "ut_assert.h"

#include <gsf/gsf-output.h>

class ABI_EXPORT IE_Exp_OpenWriter : public IE_Exp
{
public:
  IE_Exp_OpenWriter(PD_Document * pDocument);
  virtual ~IE_Exp_OpenWriter();

protected:
  virtual UT_Error	_writeDocument(void);
  virtual bool		_openFile(const char * szFilename);
  virtual bool		_closeFile(void);
  
private:
  GsfOutfile * m_oo;	
};

/*****************************************************************************/
/*****************************************************************************/

class OO_Style
{
public:
   OO_Style(UT_String &props, UT_String &name);

private:
   UT_String props;
   UT_String name;
};

/*****************************************************************************/
/*****************************************************************************/

class OO_ListenerImpl
{
public:
   OO_ListenerImpl() {}
   virtual ~OO_ListenerImpl() {}
   virtual void insertText(const UT_UCSChar * data, UT_uint32 length) = 0;
   virtual void openBlock() = 0;
   virtual void closeBlock() = 0;
   virtual void openSpan(UT_String &props) = 0;
   virtual void closeSpan() = 0;   
};

class OO_Listener : public PL_Listener
{
public:
   OO_Listener(PD_Document * pDocument, IE_Exp_OpenWriter * pie, OO_ListenerImpl *pListenerImpl);

   virtual bool populate(PL_StruxFmtHandle sfh, const PX_ChangeRecord * pcr);
   virtual bool populateStrux(PL_StruxDocHandle sdh, const PX_ChangeRecord * pcr, PL_StruxFmtHandle * psfh);
   virtual bool change(PL_StruxFmtHandle sfh, const PX_ChangeRecord * pcr);
   virtual bool insertStrux(PL_StruxFmtHandle sfh,
			    const PX_ChangeRecord * pcr,
			    PL_StruxDocHandle sdh,
			    PL_ListenerId lid,
			    void (* pfnBindHandles)(PL_StruxDocHandle sdhNew,
						    PL_ListenerId lid,
						    PL_StruxFmtHandle sfhNew));
   virtual bool signal(UT_uint32 iSignal);

   void endDocument();

private:
   void _openSpan(PT_AttrPropIndex api);
   void _closeSpan();
   void _openBlock(PT_AttrPropIndex apiSpan);
   void _closeBlock();

   bool m_bInBlock;
   bool m_bInSpan;

   OO_ListenerImpl * m_pListenerImpl;
   PD_Document * m_pDocument;
   IE_Exp_OpenWriter * m_pie;

};

class OO_StylesContainer
{
public:
   OO_StylesContainer() {}
   ~OO_StylesContainer() { UT_HASH_PURGEDATA(const int *,&m_spanStylesHash,delete); }
   void addSpanStyle(UT_String &key);
   const int getStyleNum(UT_String &key) const;
   UT_Vector * enumerateSpanStyles() const;
   UT_Vector * getSpanStylesKeys() const;
private:
   UT_StringPtrMap m_spanStylesHash;
};

/*!
 * OO_AccumulatorImpl: This class collects style definitions from the document,
 * gathering information from the listener which references it. It does not
 * actually write anything, merely storing 
 */
class OO_AccumulatorImpl : public OO_ListenerImpl
{
public:
   OO_AccumulatorImpl(OO_StylesContainer *pStylesContainer) : OO_ListenerImpl() { m_pStylesContainer = pStylesContainer; }
   virtual void insertText(const UT_UCSChar * data, UT_uint32 length) {}
   virtual void openBlock() {}
   virtual void closeBlock() {}
   virtual void openSpan(UT_String &props);
   virtual void closeSpan() {}

private:
   OO_StylesContainer *m_pStylesContainer;
};

/*!
 * OO_WriterImpl: This class writes out the content which reference the style
 * definitions which we collected earlier with the accumulator.
 */
class OO_WriterImpl : public OO_ListenerImpl
{
public:
   OO_WriterImpl(GsfOutfile *pOutfile, OO_StylesContainer *pStylesContainer);
   ~OO_WriterImpl();
   virtual void insertText(const UT_UCSChar * data, UT_uint32 length);
   virtual void openBlock();
   virtual void closeBlock();
   virtual void openSpan(UT_String &props);
   virtual void closeSpan();

private:
   GsfOutput * m_pContentStream;
   OO_StylesContainer *m_pStylesContainer;

};
