/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2003 by Leon Pennington
    email                : leon@leonscape.co.uk
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmmesh.h"

#include <klocale.h>
#include "pmxmlhelper.h"
#include "pmmeshedit.h"
#include "pmmemento.h"

const PMVector insideVectorDefault = PMVector( 0.0, 0.0, 0.0 );

PMDefinePropertyClass( PMMesh, PMProperty );

PMMetaObject* PMMesh::s_pMetaObject = 0;
PMObject* createNewMesh( PMPart* part )
{
   return new PMMesh( part );
}

PMMesh::PMMesh( PMPart* part )
      : Base( part )
{
   m_hierarchy = true;
   m_enableInsideVector = false;
   m_insideVector = insideVectorDefault;
}

PMMesh::PMMesh( const PMMesh& m )
      : Base( m )
{
   m_hierarchy = m.m_hierarchy;
   m_enableInsideVector = m.m_enableInsideVector;
   m_insideVector = m.m_insideVector;
}

PMMesh::~PMMesh( )
{
}

QString PMMesh::description( ) const
{
   return i18n( "mesh" );
}

void PMMesh::serialize( QDomElement& e, QDomDocument& doc ) const
{
   e.setAttribute( "hierarchy", m_hierarchy );
   e.setAttribute( "enable_inside_vector", m_enableInsideVector );
   e.setAttribute( "inside_vector", m_insideVector.serializeXML( ) );
   Base::serialize( e, doc );
}

void PMMesh::readAttributes( const PMXMLHelper& h )
{
   m_hierarchy = h.boolAttribute( "hierarchy", true );
   m_enableInsideVector = h.boolAttribute( "enable_inside_vector", false );
   m_insideVector = h.vectorAttribute( "inside_vector", insideVectorDefault );
   Base::readAttributes( h );
}

PMMetaObject* PMMesh::metaObject( ) const
{
   if( !s_pMetaObject )
   {
      s_pMetaObject = new PMMetaObject( "Mesh", Base::metaObject( ), createNewMesh );

      s_pMetaObject->addProperty(
         new PMProperty( "hierarchy", &PMMesh::setHierarchy, &PMMesh::hierarchy ) );
      s_pMetaObject->addProperty(
         new PMProperty( "insideVectorEnabled", &PMMesh::enableInsideVector, &PMMesh::isInsideVectorEnabled ) );
      s_pMetaObject->addProperty(
         new PMProperty( "insideVector", &PMMesh::setInsideVector, &PMMesh::insideVector ) );
   }
   return s_pMetaObject;
}

void PMMesh::cleanUp( ) const
{
   if( s_pMetaObject )
   {
      delete s_pMetaObject;
      s_pMetaObject = 0;
   }
   Base::cleanUp( );
}

void PMMesh::setHierarchy( bool h )
{
   if( h != m_hierarchy )
   {
      if( m_pMemento )
         m_pMemento->addData( s_pMetaObject, PMHierarchyID, m_hierarchy );
      m_hierarchy = h;
   }
}

void PMMesh::enableInsideVector( bool eiv )
{
   if( eiv != m_enableInsideVector )
   {
      if( m_pMemento )
         m_pMemento->addData( s_pMetaObject, PMEnableInsideVectorID, m_enableInsideVector );
      m_enableInsideVector = eiv;
   }
}

void PMMesh::setInsideVector( const PMVector& iv )
{
   if( iv != m_insideVector )
   {
      if( m_pMemento )
         m_pMemento->addData( s_pMetaObject, PMInsideVectorID, m_insideVector );
      m_insideVector = iv;
   }
}

PMDialogEditBase* PMMesh::editWidget( QWidget* parent ) const
{
   return new PMMeshEdit( parent );
}

void PMMesh::restoreMemento( PMMemento* s )
{
   PMMementoDataIterator it( s );
   PMMementoData* data;

   for( ; it.current( ); ++it )
   {
      data = it.current( );
      if( data->objectType( ) == s_pMetaObject )
      {
         switch( data->valueID( ) )
         {
            case PMHierarchyID:
               setHierarchy( data->boolData( ) );
               break;
            case PMEnableInsideVectorID:
               enableInsideVector( data->boolData( ) );
               break;
            case PMInsideVectorID:
               setInsideVector( data->vectorData( ) );
               break;
            default:
               kdError( PMArea ) << "Wrong ID in PMMesh::restoreMemento\n";
               break;
         }
      }
   }
   Base::restoreMemento( s );
}

