//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2003 by Luis Carvalho
    email                : lpassos@oninetspeed.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/

#ifndef PMLIBRARYICONVIEW_H
#define PMLIBRARYICONVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kiconview.h>

/** 
 * This class provides a view to browse objects, showing their previews.
 */
class PMLibraryIconView: public KIconView
{
   Q_OBJECT
public:
   PMLibraryIconView( QWidget *parent, const char* name = NULL );

   /** 
    * Set the library base path
    */
   void setLibraryBasePath( const QString& s );

   /**
    * refresh the icon view
    */
   void refresh( );

   /**
    * Re-implemented to disable drag of icons from the view.
    */
   virtual QDragObject* dragObject( );

private:
   QString m_basePath;
   QString m_currentPath;
};

/**
 * This class holds a library object's icon. It also remembers the path
 * where the file is.
 */
class PMLibraryIconViewItem: public KIconViewItem
{
public:
   PMLibraryIconViewItem( QIconView *parent, const QString& text, const QString& path );
   PMLibraryIconViewItem( QIconView *parent, const QString& text, const QImage& image, const QString& path );

   /** Get the path of the entry */
   QString path( ) const { return m_path; }

private:
   QString m_path;
};

#endif
