#! /bin/sh
#
# rc.M		This file is executed by init(8) when the system is being
#		initialized for one of the "multi user" run levels (i.e.
#		levels 1 through 6).  It usually does mounting of file
#		systems et al.
#
# Version:	@(#)/etc/rc.d/rc.M	2.02	02/26/93
#
# Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
#

  # Tell the viewers what's going to happen...
  echo "Going multiuser..."

  # Start update.
  /sbin/update &

  # Screen blanks after 15 minutes idle time.
  /bin/setterm -blank 15

  # Initialize the NET subsystem.
  if [ -x /etc/rc.d/rc.inet1 ];
  then
        /bin/hostname darkstar
        /bin/domainname frop.org
        /bin/sh /etc/rc.d/rc.inet1
        /bin/sh /etc/rc.d/rc.inet2
  else
        /sbin/hostname_notcp darkstar
	/bin/domainname frop.org
        echo
        echo "Since you don't have TCP/IP installed, syslogd will complain when it first"
        echo "starts. The warning can be ignored."
        echo
	/usr/sbin/syslogd
	/usr/sbin/klogd
	/usr/sbin/lpd
	/usr/sbin/crond 
  fi

  # Remove stale locks (must be done after mount -a!)
  /bin/rm -f /usr/spool/locks/* /usr/spool/uucp/LCK..* /tmp/.X*lock 1> /dev/null 2> /dev/null

  # Remove stale hunt sockets so the game can start.
  if [ -r /tmp/hunt -o -r /tmp/hunt.stats ]; then
    echo "Removing your stale hunt sockets from /tmp..."
    /bin/rm -f /tmp/hunt*
  fi

  # Update all the shared library links automatically
  /sbin/ldconfig

  # Start the local setup procedure.
  /etc/rc.d/rc.local

  # All done.
