/* linux/kernel/chr_drv/sound/dmabuf.c

A kernel module which allocates the DMA buffer for the loadable driver.

(C) 1992  Hannu Savolainen (hsavolai@cs.helsinki.fi) */

#include <linux/types.h>
#include <linux/errno.h>
#include <linux/signal.h>
#include <linux/fcntl.h>
#include <linux/sched.h>
#include <linux/timer.h>
#include <linux/tty.h>
#include <linux/ctype.h>
#include <asm/io.h>
#include <asm/segment.h>
#include <asm/system.h>
#include <sys/kd.h>
#include <linux/wait.h>
#include <linux/soundcard.h>
#include "sound_calls.h"
#include "sound_config.h"

#ifdef LOADABLE_SOUNDCARD

#define OUTB outb
#define DEB(WHAT)		/* (WHAT) */
#define DEB1(WHAT)		(WHAT)

char *sound_dma_buf[DSP_BUFFCOUNT];	/* Pointers to valid buffers */
int sound_dma_buffsize = DSP_BUFFSIZE;
int sound_dma_nbufs = 0;

static int
valid_dma_page (long addr)
{
  if (((addr & 0xffff) + sound_dma_buffsize - 1) < 0x10000)
    return 1;
  else
    return 0;
}

long
soundcard_init_stub (long mem_start)
{

  for (sound_dma_nbufs = 0; sound_dma_nbufs < DSP_BUFFCOUNT; sound_dma_nbufs++)
    {
      sound_dma_buf[sound_dma_nbufs] = (char *) mem_start;
      mem_start += DSP_BUFFSIZE;

      if (!valid_dma_page ((long) sound_dma_buf[sound_dma_nbufs]))
	{			/* Invalid buffer. Allocate new one */
	  DEB1 (printk ("Soundcard: DMA buffer at 0x%08x rejected.\n", (long) sound_dma_buf[sound_dma_nbufs]));

	  mem_start &= 0xffff0000;	/* Align address to 64k */

	  DEB1 (printk ("Leaving %d bytes of unusable memory\n", mem_start - (long) sound_dma_buf[sound_dma_nbufs]));

	  sound_dma_buf[sound_dma_nbufs] = (char *) mem_start;
	  mem_start += DSP_BUFFSIZE;
	}
      DEB (printk ("DMA buffer #%d at 0x%08x\n", sound_dma_nbufs, (long) sound_dma_buf[sound_dma_nbufs]));
    }

  return mem_start;
}

#endif
